/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.listener;

import io.meeds.content.news.model.News;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachedActivityCacheUpdater
extends Listener<String, News> {
    private static final String[] LISTENER_EVENTS = new String[]{"exo.news.postArticle", "exo.news.updateArticle", "exo.news.shareArticle", "exo.news.viewArticle", "exo.news.scheduleArticle", "exo.news.unscheduleArticle", "content.add.article.translation", "content.remove.article.translation"};
    @Autowired
    private ActivityStorage activityStorage;
    @Autowired
    private ListenerService listenerService;
    private CachedActivityStorage cachedActivityStorage;

    @PostConstruct
    public void init() {
        ActivityStorage activityStorage = this.activityStorage;
        if (activityStorage instanceof CachedActivityStorage) {
            CachedActivityStorage instance;
            this.cachedActivityStorage = instance = (CachedActivityStorage)activityStorage;
        }
        for (String listener : LISTENER_EVENTS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, News> event) throws Exception {
        if (this.cachedActivityStorage != null && event.getData() != null && StringUtils.isNotBlank((CharSequence)((News)event.getData()).getActivityId())) {
            this.cachedActivityStorage.clearActivityCached(((News)event.getData()).getActivityId());
        }
    }
}

