/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.plugin;

import io.meeds.content.news.model.News;
import io.meeds.content.news.model.filter.NewsFilter;
import io.meeds.content.news.service.NewsService;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "news";
    private static final String TITLE_KEY = "contentLink.news";
    private static final String ICON = "fa fa-newspaper";
    private static final String COMMAND = "article";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("news", "contentLink.news", "fa fa-newspaper", "article");
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private NewsService newsService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;

    @PostConstruct
    public void init() {
        this.contentLinkPluginService.addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        NewsFilter filter = new NewsFilter();
        filter.setLang(locale == null ? null : locale.toLanguageTag());
        filter.setSearchText(keyword);
        filter.setLimit(limit);
        filter.setOffset(offset);
        List<News> results = this.newsService.searchNews(filter, this.userAcl.isAnonymousUser(identity) ? null : this.identityManager.getOrCreateUserIdentity(identity.getUserId()));
        return results.stream().map(searchResult -> this.toContentLink((News)searchResult, identity, locale)).filter(Objects::nonNull).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        News news;
        News news2 = news = locale == null ? this.newsService.getNewsArticleById(objectId) : this.newsService.getNewsArticleByIdAndLang(objectId, locale.toLanguageTag());
        if (news == null && locale != null) {
            news = this.newsService.getNewsArticleById(objectId);
        }
        return news == null ? null : news.getTitle();
    }

    private ContentLinkSearchResult toContentLink(News news, Identity identity, Locale locale) {
        return new ContentLinkSearchResult(OBJECT_TYPE, news.getId(), news.getTitle(), EXTENSION.getIcon());
    }
}

