/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.rest;

import io.meeds.content.news.rest.model.NewsTargetingEntity;
import io.meeds.content.news.service.NewsTargetingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.metadata.model.Metadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"targeting"})
@Tag(name="content/rest/targeting", description="Manage targeting operations")
public class NewsTargetingRest {
    private static final Log LOG = ExoLogger.getLogger(NewsTargetingRest.class);
    @Autowired
    private NewsTargetingService newsTargetingService;

    @GetMapping(produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get all news targets", method="GET", description="Get all news targets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<List<NewsTargetingEntity>> getAllTargets() {
        try {
            List<NewsTargetingEntity> targets = this.newsTargetingService.getAllTargets();
            return ResponseEntity.ok(targets);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting the news targets", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @GetMapping(path={"allowed"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get all allowed news targets of the current user", method="GET", description="Get all allowed news targets of the current user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<List<NewsTargetingEntity>> getAllowedTargets() {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            List<NewsTargetingEntity> allowedTargets = this.newsTargetingService.getAllowedTargets(currentIdentity);
            return ResponseEntity.ok(allowedTargets);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting allowed news targets for the user " + currentIdentity.getUserId()), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @DeleteMapping(path={"{targetName}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Delete news target", method="DELETE", description="This deletes news target")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News target deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to delete the news target"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteTarget(@PathVariable(value="targetName") String targetName) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)targetName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Target name ist mandatory").build();
            }
            this.newsTargetingService.deleteTargetByName(targetName, currentIdentity);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news target with name " + targetName), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Create news target", method="POST", description="Create news target")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="User not authorized to create news target"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="409", description="Conflict operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<Metadata> createNewsTarget(@RequestBody NewsTargetingEntity newsTargetingEntity) {
        if (newsTargetingEntity.getProperties() == null || newsTargetingEntity.getProperties().get("permissions") == null || newsTargetingEntity.getProperties().get("permissions").isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            StringBuilder targetName = new StringBuilder();
            targetName.append(Utils.cleanString((String)newsTargetingEntity.getName()));
            targetName.append('_');
            targetName.append(System.currentTimeMillis());
            newsTargetingEntity.setName(targetName.toString());
            Metadata addedNewsTarget = this.newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
            return ResponseEntity.ok((Object)addedNewsTarget);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to create a news target with name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't create a news target with the same name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating a news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @PutMapping(path={"{originalTargetName}"}, consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Update an existing news target", method="PUT", description="Update an existing news target")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="409", description="Conflict operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNewsTarget(@RequestBody NewsTargetingEntity newsTargetingEntity, @PathVariable(value="originalTargetName") String originalTargetName) {
        if (newsTargetingEntity.getProperties() == null || newsTargetingEntity.getProperties().get("permissions") == null || newsTargetingEntity.getProperties().get("permissions").isEmpty()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Metadata metadata = this.newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity);
            return Response.ok((Object)metadata).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (IllegalStateException e) {
            LOG.warn("The news target '{}' can't be found", new Object[]{newsTargetingEntity.getName(), e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when updating the news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GetMapping(path={"{targetName}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get article target by its name", method="GET", description="Get article target by its name")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<NewsTargetingEntity> getTargetByName(@PathVariable(value="targetName") String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return ResponseEntity.badRequest().build();
        }
        try {
            NewsTargetingEntity newsTargetingEntity = this.newsTargetingService.getTargetByName(targetName);
            if (newsTargetingEntity == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)newsTargetingEntity);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

