/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.upgrade;

import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CleanDuplicatedEsIndexesUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)CleanDuplicatedEsIndexesUpgrade.class.getName());
    private ElasticSearchingClient elasticSearchingClient;
    private IndexingService indexingService;
    private NewsService newsService;
    private SettingService settingService;
    private int cleanedDuplicatedNewsEsIndexesCount = 0;
    private boolean cleanupFailed = false;
    private static final String PLUGIN_NAME = "CleanDuplicatedEsIndexesUpgrade";
    private static final String PLUGIN_EXECUTED_KEY = "cleanDuplicatedEsIndexesUpgradeExecuted";

    public CleanDuplicatedEsIndexesUpgrade(InitParams initParams, NewsService newsService, ElasticSearchingClient elasticSearchingClient, IndexingService indexingService, SettingService settingService) {
        super(initParams);
        this.newsService = newsService;
        this.elasticSearchingClient = elasticSearchingClient;
        this.indexingService = indexingService;
        this.settingService = settingService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start cleanup of duplicated News ES indexes");
        int notCleanedDuplicatedNewsEsIndexesCount = 0;
        int processedDuplicatedNewsEsIndexesCount = 0;
        int totalDuplicatedNewsEsIndexesCount = 0;
        try {
            String matchAllQuery = "{\n  \"query\": {\n    \"match_all\": {}\n  },\n  \"size\": 10000\n}";
            String notesMatchAllQueryResponse = this.elasticSearchingClient.sendRequest(matchAllQuery, "notes_v1");
            List<String> duplicatedNewsEsIndexes = this.getDuplicatedNewsEsIndexes(notesMatchAllQueryResponse);
            if (duplicatedNewsEsIndexes != null) {
                totalDuplicatedNewsEsIndexesCount = duplicatedNewsEsIndexes.size();
                LOG.info("Total number of duplicated News ES indexes to be cleaned: {}", new Object[]{totalDuplicatedNewsEsIndexesCount});
                if (duplicatedNewsEsIndexes != null) {
                    for (List duplicatedNewsEsIndexesChunk : ListUtils.partition(duplicatedNewsEsIndexes, (int)10)) {
                        int processedDuplicatedNewsEsIndexesCountByTransaction = duplicatedNewsEsIndexesChunk.size();
                        int notCleanedDuplicatedNewsEsIndexesCountByTransaction = this.manageDuplicatedNewsEsIndexes(duplicatedNewsEsIndexesChunk);
                        this.cleanedDuplicatedNewsEsIndexesCount += processedDuplicatedNewsEsIndexesCountByTransaction - notCleanedDuplicatedNewsEsIndexesCountByTransaction;
                        LOG.info("Duplicated News ES indexes cleanup progress: processed={}/{} succeeded={} error={}", new Object[]{processedDuplicatedNewsEsIndexesCount += processedDuplicatedNewsEsIndexesCountByTransaction, totalDuplicatedNewsEsIndexesCount, this.cleanedDuplicatedNewsEsIndexesCount, notCleanedDuplicatedNewsEsIndexesCount += notCleanedDuplicatedNewsEsIndexesCountByTransaction});
                    }
                }
            }
        }
        catch (Exception e) {
            this.cleanupFailed = true;
            LOG.error((Object)"An error occurred when cleanup duplicated News ES indexes:", (Throwable)e);
        }
        if (this.cleanupFailed || totalDuplicatedNewsEsIndexesCount != this.cleanedDuplicatedNewsEsIndexesCount) {
            LOG.warn("End duplicated News ES indexes cleanup with some errors: total={} succeeded={} error={}. It tooks {} ms. The not cleaned news articles will be processed again next startup.", new Object[]{totalDuplicatedNewsEsIndexesCount, this.cleanedDuplicatedNewsEsIndexesCount, notCleanedDuplicatedNewsEsIndexesCount, System.currentTimeMillis() - startupTime});
            this.cleanupFailed = true;
            throw new IllegalStateException("Some duplicated News ES indexes wasn't executed successfully. It will be re-attempted next startup");
        }
        LOG.info("End duplicated News ES indexes successful cleanup: total={} succeeded={} error={}. It tooks {} ms.", new Object[]{totalDuplicatedNewsEsIndexesCount, this.cleanedDuplicatedNewsEsIndexesCount, notCleanedDuplicatedNewsEsIndexesCount, System.currentTimeMillis() - startupTime});
    }

    public void afterUpgrade() {
        if (!this.cleanupFailed) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext upgradePluginExecutionContext) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY);
        boolean shouldUpgrade = super.shouldProceedToUpgrade(newVersion, previousGroupVersion, upgradePluginExecutionContext);
        if (!shouldUpgrade && settingValue == null) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
        return shouldUpgrade;
    }

    public int manageDuplicatedNewsEsIndexes(List<String> duplicatedNewsEsIndexes) {
        int notCleanedDuplicatedNewsEsIndexesCountByTransaction = 0;
        for (String duplicatedNewsEsIndex : duplicatedNewsEsIndexes) {
            try {
                LOG.info("Cleaning duplicated News ES index with id '{}'", new Object[]{duplicatedNewsEsIndex});
                this.indexingService.unindex("wiki-page", duplicatedNewsEsIndex);
                LOG.info("Success cleaning News ES index with id '{}'", new Object[]{duplicatedNewsEsIndex});
            }
            catch (Exception e) {
                ++notCleanedDuplicatedNewsEsIndexesCountByTransaction;
                LOG.warn("Error cleaning duplicated news ES index with id '{}'. Continue to migrate other items", new Object[]{duplicatedNewsEsIndex, e});
            }
        }
        return notCleanedDuplicatedNewsEsIndexesCountByTransaction;
    }

    public int getCleanedDuplicatedNewsEsIndexesCount() {
        return this.cleanedDuplicatedNewsEsIndexesCount;
    }

    private List<String> getDuplicatedNewsEsIndexes(String queryResponse) {
        Map queryJsonResponse;
        ArrayList<String> duplicatedNewsEsIndexes = new ArrayList<String>();
        JSONParser parser = new JSONParser();
        try {
            queryJsonResponse = (Map)parser.parse(queryResponse);
        }
        catch (ParseException e) {
            return null;
        }
        JSONObject queryJsonResult = (JSONObject)queryJsonResponse.get("hits");
        JSONArray queryJsonHits = (JSONArray)queryJsonResult.get((Object)"hits");
        for (Object queryJsonHit : queryJsonHits) {
            String noteId;
            String articleId = noteId = ((JSONObject)queryJsonHit).get((Object)"_id").toString();
            if (noteId.contains("-")) {
                articleId = noteId.substring(0, noteId.indexOf("-"));
            }
            News article = null;
            try {
                article = this.newsService.buildArticle(articleId);
                if (article == null || article.isReferred() || article.isFromExternalPage()) continue;
                duplicatedNewsEsIndexes.add(noteId);
            }
            catch (Exception e) {
                LOG.warn("Error retrieving article id '{}'", new Object[]{noteId});
            }
        }
        return duplicatedNewsEsIndexes;
    }
}

