/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import io.meeds.portal.mop.storage.cache.model.DescriptionLocaleListCache;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.dao.DescriptionDAO;
import org.exoplatform.portal.mop.storage.DescriptionStorageImpl;
import org.exoplatform.portal.mop.storage.cache.model.DescriptionCacheKey;
import org.exoplatform.portal.mop.storage.cache.model.DescriptionCacheSelector;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CacheDescriptionStorage
extends DescriptionStorageImpl {
    private static final Log LOG = ExoLogger.getExoLogger(CacheDescriptionStorage.class);
    public static final DescriptionLocaleListCache NULL_LOCALE_LIST = new DescriptionLocaleListCache();
    public static final String DESCRIPTION_CACHE_NAME = "portal.DescriptionService";
    public static final String DESCRIPTION_LOCLES_CACHE_NAME = "portal.DescriptionLocales";
    private final FutureExoCache<DescriptionCacheKey, State, Object> descriptionFutureCache;
    private final ExoCache<DescriptionCacheKey, State> descriptionCache;
    private final FutureExoCache<String, DescriptionLocaleListCache, Object> descriptionLocaleListFutureCache;
    private final ExoCache<String, DescriptionLocaleListCache> descriptionLocaleListCache;

    public CacheDescriptionStorage(CacheService cacheService, DescriptionDAO descriptionDAO) {
        super(descriptionDAO);
        this.descriptionCache = cacheService.getCacheInstance(DESCRIPTION_CACHE_NAME);
        this.descriptionFutureCache = new FutureExoCache((Loader)new Loader<DescriptionCacheKey, State, Object>(){

            public State retrieve(Object context, DescriptionCacheKey cacheKey) throws Exception {
                State description = CacheDescriptionStorage.super.getDescription(cacheKey.getId(), cacheKey.getLocale(), cacheKey.isIncludeParent());
                return description == null ? State.NULL_OBJECT : description;
            }
        }, this.descriptionCache);
        this.descriptionLocaleListCache = cacheService.getCacheInstance(DESCRIPTION_LOCLES_CACHE_NAME);
        this.descriptionLocaleListFutureCache = new FutureExoCache((Loader)new Loader<String, DescriptionLocaleListCache, Object>(){

            public DescriptionLocaleListCache retrieve(Object context, String id) throws Exception {
                Map descriptions = CacheDescriptionStorage.super.getDescriptions(id);
                return MapUtils.isEmpty((Map)descriptions) ? NULL_LOCALE_LIST : new DescriptionLocaleListCache(descriptions.keySet());
            }
        }, this.descriptionLocaleListCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String id, Locale locale, State description) {
        try {
            super.setDescription(id, locale, description);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public void setDescription(String id, State description) {
        try {
            super.setDescription(id, description);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public void setDescriptions(String id, Map<Locale, State> descriptions) {
        try {
            super.setDescriptions(id, descriptions);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public State getDescription(String id, Locale locale, boolean checkParent) {
        State desccription = (State)this.descriptionFutureCache.get(null, (Object)new DescriptionCacheKey(id, locale, checkParent));
        return desccription == null || desccription.isNull() ? null : desccription;
    }

    @Override
    public Map<Locale, State> getDescriptions(String id) {
        DescriptionLocaleListCache descriptionLocaleList = (DescriptionLocaleListCache)this.descriptionLocaleListFutureCache.get(null, (Object)id);
        return descriptionLocaleList == null || CollectionUtils.isEmpty(descriptionLocaleList.getLocales()) ? null : descriptionLocaleList.getLocales().stream().filter(Objects::nonNull).map(l -> Pair.of((Object)l, (Object)this.getDescription(id, (Locale)l))).filter(p -> p.getKey() != null && p.getValue() != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private void clearCacheEntries(String id) {
        try {
            this.descriptionCache.select((CachedObjectSelector)new DescriptionCacheSelector(id));
            this.descriptionLocaleListCache.clearCache();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error selecting cache entries to clear, clear all entries", (Throwable)e);
            this.descriptionCache.clearCache();
        }
    }
}

