/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.ValueType;
import co.elastic.clients.elasticsearch._types.aggregations.WeightedAverageValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WeightedAverageAggregation
extends AggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final String format;
    @Nullable
    private final WeightedAverageValue value;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private final WeightedAverageValue weight;
    public static final JsonpDeserializer<WeightedAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageAggregation::setupWeightedAverageAggregationDeserializer);

    private WeightedAverageAggregation(Builder builder) {
        this.format = builder.format;
        this.value = builder.value;
        this.valueType = builder.valueType;
        this.weight = builder.weight;
    }

    public static WeightedAverageAggregation of(Function<Builder, ObjectBuilder<WeightedAverageAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.WeightedAvg;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final WeightedAverageValue value() {
        return this.value;
    }

    @Nullable
    public final ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public final WeightedAverageValue weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            this.weight.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWeightedAverageAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::value, WeightedAverageValue._DESERIALIZER, "value");
        op.add(Builder::valueType, ValueType._DESERIALIZER, "value_type");
        op.add(Builder::weight, WeightedAverageValue._DESERIALIZER, "weight");
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WeightedAverageAggregation> {
        @Nullable
        private String format;
        @Nullable
        private WeightedAverageValue value;
        @Nullable
        private ValueType valueType;
        @Nullable
        private WeightedAverageValue weight;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder value(@Nullable WeightedAverageValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.value(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        public final Builder valueType(@Nullable ValueType value) {
            this.valueType = value;
            return this;
        }

        public final Builder weight(@Nullable WeightedAverageValue value) {
            this.weight = value;
            return this;
        }

        public final Builder weight(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.weight(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WeightedAverageAggregation build() {
            this._checkSingleUse();
            return new WeightedAverageAggregation(this);
        }
    }
}

