/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_migrate_reindex_status.StatusError;
import co.elastic.clients.elasticsearch.indices.get_migrate_reindex_status.StatusInProgress;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetMigrateReindexStatusResponse
implements JsonpSerializable {
    @Nullable
    private final DateTime startTime;
    private final long startTimeMillis;
    private final boolean complete;
    private final int totalIndicesInDataStream;
    private final int totalIndicesRequiringUpgrade;
    private final int successes;
    private final List<StatusInProgress> inProgress;
    private final int pending;
    private final List<StatusError> errors;
    @Nullable
    private final String exception;
    public static final JsonpDeserializer<GetMigrateReindexStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetMigrateReindexStatusResponse::setupGetMigrateReindexStatusResponseDeserializer);

    private GetMigrateReindexStatusResponse(Builder builder) {
        this.startTime = builder.startTime;
        this.startTimeMillis = ApiTypeHelper.requireNonNull(builder.startTimeMillis, (Object)this, "startTimeMillis", 0L);
        this.complete = ApiTypeHelper.requireNonNull(builder.complete, (Object)this, "complete", false);
        this.totalIndicesInDataStream = ApiTypeHelper.requireNonNull(builder.totalIndicesInDataStream, (Object)this, "totalIndicesInDataStream", 0);
        this.totalIndicesRequiringUpgrade = ApiTypeHelper.requireNonNull(builder.totalIndicesRequiringUpgrade, (Object)this, "totalIndicesRequiringUpgrade", 0);
        this.successes = ApiTypeHelper.requireNonNull(builder.successes, (Object)this, "successes", 0);
        this.inProgress = ApiTypeHelper.unmodifiableRequired(builder.inProgress, (Object)this, "inProgress");
        this.pending = ApiTypeHelper.requireNonNull(builder.pending, (Object)this, "pending", 0);
        this.errors = ApiTypeHelper.unmodifiableRequired(builder.errors, (Object)this, "errors");
        this.exception = builder.exception;
    }

    public static GetMigrateReindexStatusResponse of(Function<Builder, ObjectBuilder<GetMigrateReindexStatusResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime startTime() {
        return this.startTime;
    }

    public final long startTimeMillis() {
        return this.startTimeMillis;
    }

    public final boolean complete() {
        return this.complete;
    }

    public final int totalIndicesInDataStream() {
        return this.totalIndicesInDataStream;
    }

    public final int totalIndicesRequiringUpgrade() {
        return this.totalIndicesRequiringUpgrade;
    }

    public final int successes() {
        return this.successes;
    }

    public final List<StatusInProgress> inProgress() {
        return this.inProgress;
    }

    public final int pending() {
        return this.pending;
    }

    public final List<StatusError> errors() {
        return this.errors;
    }

    @Nullable
    public final String exception() {
        return this.exception;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
        generator.writeKey("start_time_millis");
        generator.write(this.startTimeMillis);
        generator.writeKey("complete");
        generator.write(this.complete);
        generator.writeKey("total_indices_in_data_stream");
        generator.write(this.totalIndicesInDataStream);
        generator.writeKey("total_indices_requiring_upgrade");
        generator.write(this.totalIndicesRequiringUpgrade);
        generator.writeKey("successes");
        generator.write(this.successes);
        if (ApiTypeHelper.isDefined(this.inProgress)) {
            generator.writeKey("in_progress");
            generator.writeStartArray();
            for (StatusInProgress statusInProgress : this.inProgress) {
                statusInProgress.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("pending");
        generator.write(this.pending);
        if (ApiTypeHelper.isDefined(this.errors)) {
            generator.writeKey("errors");
            generator.writeStartArray();
            for (StatusError statusError : this.errors) {
                statusError.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.exception != null) {
            generator.writeKey("exception");
            generator.write(this.exception);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetMigrateReindexStatusResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
        op.add(Builder::startTimeMillis, JsonpDeserializer.longDeserializer(), "start_time_millis");
        op.add(Builder::complete, JsonpDeserializer.booleanDeserializer(), "complete");
        op.add(Builder::totalIndicesInDataStream, JsonpDeserializer.integerDeserializer(), "total_indices_in_data_stream");
        op.add(Builder::totalIndicesRequiringUpgrade, JsonpDeserializer.integerDeserializer(), "total_indices_requiring_upgrade");
        op.add(Builder::successes, JsonpDeserializer.integerDeserializer(), "successes");
        op.add(Builder::inProgress, JsonpDeserializer.arrayDeserializer(StatusInProgress._DESERIALIZER), "in_progress");
        op.add(Builder::pending, JsonpDeserializer.integerDeserializer(), "pending");
        op.add(Builder::errors, JsonpDeserializer.arrayDeserializer(StatusError._DESERIALIZER), "errors");
        op.add(Builder::exception, JsonpDeserializer.stringDeserializer(), "exception");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetMigrateReindexStatusResponse> {
        @Nullable
        private DateTime startTime;
        private Long startTimeMillis;
        private Boolean complete;
        private Integer totalIndicesInDataStream;
        private Integer totalIndicesRequiringUpgrade;
        private Integer successes;
        private List<StatusInProgress> inProgress;
        private Integer pending;
        private List<StatusError> errors;
        @Nullable
        private String exception;

        public final Builder startTime(@Nullable DateTime value) {
            this.startTime = value;
            return this;
        }

        public final Builder startTimeMillis(long value) {
            this.startTimeMillis = value;
            return this;
        }

        public final Builder complete(boolean value) {
            this.complete = value;
            return this;
        }

        public final Builder totalIndicesInDataStream(int value) {
            this.totalIndicesInDataStream = value;
            return this;
        }

        public final Builder totalIndicesRequiringUpgrade(int value) {
            this.totalIndicesRequiringUpgrade = value;
            return this;
        }

        public final Builder successes(int value) {
            this.successes = value;
            return this;
        }

        public final Builder inProgress(List<StatusInProgress> list) {
            this.inProgress = Builder._listAddAll(this.inProgress, list);
            return this;
        }

        public final Builder inProgress(StatusInProgress value, StatusInProgress ... values) {
            this.inProgress = Builder._listAdd(this.inProgress, value, values);
            return this;
        }

        public final Builder inProgress(Function<StatusInProgress.Builder, ObjectBuilder<StatusInProgress>> fn) {
            return this.inProgress(fn.apply(new StatusInProgress.Builder()).build(), new StatusInProgress[0]);
        }

        public final Builder pending(int value) {
            this.pending = value;
            return this;
        }

        public final Builder errors(List<StatusError> list) {
            this.errors = Builder._listAddAll(this.errors, list);
            return this;
        }

        public final Builder errors(StatusError value, StatusError ... values) {
            this.errors = Builder._listAdd(this.errors, value, values);
            return this;
        }

        public final Builder errors(Function<StatusError.Builder, ObjectBuilder<StatusError>> fn) {
            return this.errors(fn.apply(new StatusError.Builder()).build(), new StatusError[0]);
        }

        public final Builder exception(@Nullable String value) {
            this.exception = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetMigrateReindexStatusResponse build() {
            this._checkSingleUse();
            return new GetMigrateReindexStatusResponse(this);
        }
    }
}

