/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AppliesTo;
import co.elastic.clients.elasticsearch.ml.ConditionOperator;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RuleCondition
implements JsonpSerializable {
    private final AppliesTo appliesTo;
    private final ConditionOperator operator;
    private final double value;
    public static final JsonpDeserializer<RuleCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuleCondition::setupRuleConditionDeserializer);

    private RuleCondition(Builder builder) {
        this.appliesTo = ApiTypeHelper.requireNonNull(builder.appliesTo, this, "appliesTo");
        this.operator = ApiTypeHelper.requireNonNull(builder.operator, this, "operator");
        this.value = ApiTypeHelper.requireNonNull(builder.value, (Object)this, "value", 0.0);
    }

    public static RuleCondition of(Function<Builder, ObjectBuilder<RuleCondition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AppliesTo appliesTo() {
        return this.appliesTo;
    }

    public final ConditionOperator operator() {
        return this.operator;
    }

    public final double value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("applies_to");
        this.appliesTo.serialize(generator, mapper);
        generator.writeKey("operator");
        this.operator.serialize(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRuleConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::appliesTo, AppliesTo._DESERIALIZER, "applies_to");
        op.add(Builder::operator, ConditionOperator._DESERIALIZER, "operator");
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RuleCondition> {
        private AppliesTo appliesTo;
        private ConditionOperator operator;
        private Double value;

        public final Builder appliesTo(AppliesTo value) {
            this.appliesTo = value;
            return this;
        }

        public final Builder operator(ConditionOperator value) {
            this.operator = value;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuleCondition build() {
            this._checkSingleUse();
            return new RuleCondition(this);
        }
    }
}

