/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.rollup.FieldMetric;
import co.elastic.clients.elasticsearch.rollup.Groupings;
import co.elastic.clients.elasticsearch.rollup.PutJobResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@Deprecated
@JsonpDeserializable
public class PutJobRequest
extends RequestBase
implements JsonpSerializable {
    private final String cron;
    private final Groupings groups;
    private final Map<String, List<String>> headers;
    private final String id;
    private final String indexPattern;
    private final List<FieldMetric> metrics;
    private final int pageSize;
    private final String rollupIndex;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJobRequest::setupPutJobRequestDeserializer);
    public static final Endpoint<PutJobRequest, PutJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutJobRequest, PutJobResponse>("es/rollup.put_job", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rollup");
            buf.append("/job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutJobResponse._DESERIALIZER);

    private PutJobRequest(Builder builder) {
        this.cron = ApiTypeHelper.requireNonNull(builder.cron, this, "cron");
        this.groups = ApiTypeHelper.requireNonNull(builder.groups, this, "groups");
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.indexPattern = ApiTypeHelper.requireNonNull(builder.indexPattern, this, "indexPattern");
        this.metrics = ApiTypeHelper.unmodifiable(builder.metrics);
        this.pageSize = ApiTypeHelper.requireNonNull(builder.pageSize, (Object)this, "pageSize", 0);
        this.rollupIndex = ApiTypeHelper.requireNonNull(builder.rollupIndex, this, "rollupIndex");
        this.timeout = builder.timeout;
    }

    public static PutJobRequest of(Function<Builder, ObjectBuilder<PutJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String cron() {
        return this.cron;
    }

    public final Groupings groups() {
        return this.groups;
    }

    public final Map<String, List<String>> headers() {
        return this.headers;
    }

    public final String id() {
        return this.id;
    }

    public final String indexPattern() {
        return this.indexPattern;
    }

    public final List<FieldMetric> metrics() {
        return this.metrics;
    }

    public final int pageSize() {
        return this.pageSize;
    }

    public final String rollupIndex() {
        return this.rollupIndex;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cron");
        generator.write(this.cron);
        generator.writeKey("groups");
        this.groups.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (FieldMetric fieldMetric : this.metrics) {
                fieldMetric.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("page_size");
        generator.write(this.pageSize);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    protected static void setupPutJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron");
        op.add(Builder::groups, Groupings._DESERIALIZER, "groups");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers");
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern");
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(FieldMetric._DESERIALIZER), "metrics");
        op.add(Builder::pageSize, JsonpDeserializer.integerDeserializer(), "page_size");
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    @Deprecated
    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutJobRequest> {
        private String cron;
        private Groupings groups;
        @Nullable
        private Map<String, List<String>> headers;
        private String id;
        private String indexPattern;
        @Nullable
        private List<FieldMetric> metrics;
        private Integer pageSize;
        private String rollupIndex;
        @Nullable
        private Time timeout;

        public final Builder cron(String value) {
            this.cron = value;
            return this;
        }

        public final Builder groups(Groupings value) {
            this.groups = value;
            return this;
        }

        public final Builder groups(Function<Groupings.Builder, ObjectBuilder<Groupings>> fn) {
            return this.groups(fn.apply(new Groupings.Builder()).build());
        }

        public final Builder headers(Map<String, List<String>> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, List<String> value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public final Builder metrics(List<FieldMetric> list) {
            this.metrics = Builder._listAddAll(this.metrics, list);
            return this;
        }

        public final Builder metrics(FieldMetric value, FieldMetric ... values) {
            this.metrics = Builder._listAdd(this.metrics, value, values);
            return this;
        }

        public final Builder metrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.metrics(fn.apply(new FieldMetric.Builder()).build(), new FieldMetric[0]);
        }

        public final Builder pageSize(int value) {
            this.pageSize = value;
            return this;
        }

        public final Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutJobRequest build() {
            this._checkSingleUse();
            return new PutJobRequest(this);
        }
    }
}

