/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardsStatsSummaryItem
implements JsonpSerializable {
    private final long fileCount;
    private final long sizeInBytes;
    public static final JsonpDeserializer<ShardsStatsSummaryItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStatsSummaryItem::setupShardsStatsSummaryItemDeserializer);

    private ShardsStatsSummaryItem(Builder builder) {
        this.fileCount = ApiTypeHelper.requireNonNull(builder.fileCount, (Object)this, "fileCount", 0L);
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
    }

    public static ShardsStatsSummaryItem of(Function<Builder, ObjectBuilder<ShardsStatsSummaryItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long fileCount() {
        return this.fileCount;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("file_count");
        generator.write(this.fileCount);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardsStatsSummaryItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fileCount, JsonpDeserializer.longDeserializer(), "file_count");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsStatsSummaryItem> {
        private Long fileCount;
        private Long sizeInBytes;

        public final Builder fileCount(long value) {
            this.fileCount = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsStatsSummaryItem build() {
            this._checkSingleUse();
            return new ShardsStatsSummaryItem(this);
        }
    }
}

