/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.activity.processor;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityKudosProcessor
extends BaseActivityProcessorPlugin {
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private KudosService kudosService;

    public ActivityKudosProcessor() {
        super(ActivityKudosProcessor.initParams());
    }

    public String getName() {
        return "ActivityKudosProcessor";
    }

    @PostConstruct
    public void init() {
        this.activityManager.addProcessor((ActivityProcessor)this);
    }

    public void processActivity(ExoSocialActivity activity) {
        List<Kudos> linkedKudosList;
        if (activity.isComment()) {
            return;
        }
        if (activity.getLinkedProcessedEntities() == null) {
            activity.setLinkedProcessedEntities(new HashMap());
        }
        if ((linkedKudosList = (List<Kudos>)activity.getLinkedProcessedEntities().get("kudosList")) == null) {
            linkedKudosList = this.kudosService.getKudosListOfActivity(activity.getId());
            activity.getLinkedProcessedEntities().put("kudosList", linkedKudosList);
        }
        if (linkedKudosList != null) {
            for (Kudos kudos : linkedKudosList) {
                Utils.transformKudosMessage(kudos);
            }
        }
    }

    private static InitParams initParams() {
        InitParams initParams = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("priority");
        param.setValue("20");
        initParams.addParameter((Parameter)param);
        return initParams;
    }
}

