/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.wallet;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"wallet"})
@Component
public class RewardSucceededPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String REWARD_ADMINISTRATION_URL = "/portal/administration/home/rewards/reward";
    private static final String TITLE_LABEL_KEY = "pwa.notification.RewardSuccessNotificationPlugin.title";
    private static final String BODY_LABEL_KEY = "pwa.notification.RewardSuccessNotificationPlugin.body";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("d MMM uuuu");
    @Autowired
    private ResourceBundleService resourceBundleService;

    public String getId() {
        return "RewardSuccessNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        Locale locale = localeConfig.getLocale();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, locale));
        notificationMessage.setBody(this.resourceBundleService.getSharedString(BODY_LABEL_KEY, locale).replace("{0}", this.getDateLabel(notification, "rewardStartPeriodDate", locale)).replace("{1}", this.getDateLabel(notification, "rewardEndPeriodDate", locale)));
        notificationMessage.setUrl(REWARD_ADMINISTRATION_URL);
        return notificationMessage;
    }

    private String getDateLabel(NotificationInfo notification, String key, Locale locale) {
        String rewardStartPeriodDate = notification.getValueOwnerParameter(key);
        return RewardSucceededPwaNotificationPlugin.formatTime(rewardStartPeriodDate, ZoneOffset.UTC, locale);
    }

    private static String formatTime(Object timeInSeconds, ZoneId zoneId, Locale userLocale) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(String.valueOf(timeInSeconds))), zoneId);
        return dateTime.format(DATE_FORMATTER.withLocale(userLocale));
    }
}

