/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jboss.util.JBossObject;
import org.jboss.util.stream.Streams;

public final class Objects {
    public static Constructor getCompatibleConstructor(Class type, Class valueType) {
        try {
            return type.getConstructor(valueType);
        }
        catch (Exception ignore) {
            Class<?>[] types = type.getClasses();
            for (int i = 0; i < types.length; ++i) {
                try {
                    return type.getConstructor(types[i]);
                }
                catch (Exception ignore2) {
                    continue;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object copy(Serializable obj) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.flush();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            in = new ObjectInputStream(bais);
            copy = in.readObject();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            Streams.close(in);
            throw throwable;
        }
        Streams.close(out);
        Streams.close(in);
        return copy;
    }

    public static Object deref(Object obj) {
        if (obj != null && obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return ref.get();
        }
        return obj;
    }

    public static <T> T deref(Object obj, Class<T> expected) {
        Object result = Objects.deref(obj);
        if (result == null) {
            return null;
        }
        return expected.cast(result);
    }

    public static boolean isArray(Object obj) {
        if (obj != null) {
            return obj.getClass().isArray();
        }
        return false;
    }

    public static Object[] toArray(Object obj) {
        Object array;
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            int length = Array.getLength(obj);
            Class<?> componentType = type.getComponentType();
            array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, Array.get(obj, i));
            }
        } else {
            array = Array.newInstance(type, 1);
            Array.set(array, 0, obj);
        }
        return (Object[])array;
    }

    public static boolean equals(Object[] a, Object[] b, boolean deep) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            Object x = a[i];
            Object y = b[i];
            if (x != y) {
                return false;
            }
            if (x == null || y == null) {
                return false;
            }
            if (deep) {
                if (x instanceof Object[] && y instanceof Object[]) {
                    if (!Objects.equals((Object[])x, (Object[])y, true)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (x.equals(y)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] b) {
        return Objects.equals(a, b, true);
    }

    public static boolean equals(Object first, Object second) {
        if (Objects.isArray(first)) {
            if (!Objects.isArray(second)) {
                return false;
            }
            int lenght = Array.getLength(first);
            if (lenght != Array.getLength(second)) {
                return false;
            }
            for (int i = 0; i < lenght; ++i) {
                if (Objects.equals(Array.get(first, i), Array.get(second, i))) continue;
                return false;
            }
            return true;
        }
        return JBossObject.equals(first, second);
    }
}

