/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Activation", description="Component that handles activating entries that have been passivated to a CacheStore by loading them into memory.")
public class ActivationManagerImpl
implements ActivationManager {
    private static final Log log = LogFactory.getLog(ActivationManagerImpl.class);
    private final AtomicLong activations = new AtomicLong(0L);
    private PersistenceManager persistenceManager;
    private Configuration cfg;
    private ClusteringDependentLogic clusteringDependentLogic;
    private boolean passivation;
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", writable=true)
    private boolean statisticsEnabled = false;

    @Inject
    public void inject(PersistenceManager clm, Configuration cfg, ClusteringDependentLogic cdl) {
        this.persistenceManager = clm;
        this.cfg = cfg;
        this.clusteringDependentLogic = cdl;
    }

    @Start(priority=11)
    public void start() {
        this.statisticsEnabled = this.cfg.jmxStatistics().enabled();
        this.passivation = this.cfg.persistence().passivation();
    }

    @Override
    public void onUpdate(Object key, boolean newEntry) {
        if (!this.passivation || !newEntry) {
            return;
        }
        try {
            if (this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.PRIVATE) && this.statisticsEnabled) {
                this.activations.incrementAndGet();
            }
        }
        catch (CacheException e) {
            log.unableToRemoveEntryAfterActivation(key, (Exception)((Object)e));
        }
    }

    @Override
    public void onRemove(Object key, boolean newEntry) {
        if (!this.passivation) {
            return;
        }
        boolean primaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
        try {
            if (newEntry) {
                PersistenceManager.AccessMode mode;
                PersistenceManager.AccessMode accessMode = mode = primaryOwner ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE;
                if (this.persistenceManager.deleteFromAllStores(key, mode) && this.statisticsEnabled) {
                    this.activations.incrementAndGet();
                }
            } else if (primaryOwner && this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.SHARED) && this.statisticsEnabled) {
                this.activations.incrementAndGet();
            }
        }
        catch (CacheException e) {
            log.unableToRemoveEntryAfterActivation(key, (Exception)((Object)e));
        }
    }

    @Override
    public long getActivationCount() {
        return this.activations.get();
    }

    @ManagedAttribute(description="Number of activation events", displayName="Number of cache entries activated", measurementType=MeasurementType.TRENDSUP)
    public String getActivations() {
        if (!this.statisticsEnabled) {
            return "N/A";
        }
        return String.valueOf(this.getActivationCount());
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.activations.set(0L);
    }
}

