/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.plugin;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.upgrade.UpgradePluginException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataType;

public class CategoryLinkPermissionsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(CategoryLinkPermissionsUpgradePlugin.class);
    private static final MetadataType METADATA_TYPE = new MetadataType(54175L, "category");
    private static final String PROP_LINK_PERMISSIONS = "categoryLinkPermissions";
    private static final String PROP_ACCESS_PERMISSIONS = "categoryAccessPermissions";
    private static final String GROUP_PROVIDER_ID = "group";
    private MetadataService metadataService;
    private IdentityManager identityManager;

    public CategoryLinkPermissionsUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start:: Upgrade Categories link permissions");
        int count = 0;
        int errorCount = 0;
        try {
            List metadataIds = this.getMetadataService().getMetadataIds(METADATA_TYPE.getName(), 0, -1);
            for (Long metadataId : metadataIds) {
                try {
                    Metadata metadata = this.getMetadataService().getMetadataById(metadataId.longValue());
                    List<String> categoryLinkPermissions = this.toList(MapUtils.getString((Map)metadata.getProperties(), (Object)PROP_LINK_PERMISSIONS));
                    if (categoryLinkPermissions == null || categoryLinkPermissions.isEmpty() || categoryLinkPermissions.stream().allMatch(id -> id != null && !StringUtils.isNumeric((CharSequence)id))) continue;
                    ArrayList<CallSite> upgradedPermissions = new ArrayList<CallSite>();
                    for (String permissionId : categoryLinkPermissions) {
                        if (permissionId == null || permissionId.trim().isEmpty() || !StringUtils.isNumeric((CharSequence)permissionId)) continue;
                        long id2 = Long.parseLong(permissionId.trim());
                        Identity identity = this.getIdentityManager().getIdentity(id2);
                        if (identity == null) continue;
                        String groupId = "";
                        if (identity.isSpace()) {
                            groupId = String.format("/spaces/%s", identity.getRemoteId());
                        } else if (identity.getProviderId().equals(GROUP_PROVIDER_ID)) {
                            groupId = identity.getRemoteId();
                        }
                        upgradedPermissions.add((CallSite)((Object)("*:" + groupId)));
                    }
                    if (upgradedPermissions.isEmpty()) continue;
                    metadata.getProperties().put(PROP_LINK_PERMISSIONS, String.valueOf(upgradedPermissions));
                    metadata.getProperties().remove(PROP_ACCESS_PERMISSIONS);
                    this.getMetadataService().updateMetadata(metadata);
                    ++count;
                }
                catch (Exception e) {
                    ++errorCount;
                    LOG.debug("Error while upgrading metadata with id {}, Continue processing other categories", new Object[]{metadataId, e});
                }
            }
        }
        catch (Exception e) {
            throw new UpgradePluginException("Unexpected error upgrading category link permissions", (Throwable)e);
        }
        if (errorCount > 0) {
            throw new UpgradePluginException(String.format("End:: Upgrade Categories link permissions: %s/%s has been upgraded", count - errorCount, count));
        }
        LOG.info("End:: Upgrade Categories link permissions: {} successes.", new Object[]{count});
    }

    private MetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = (MetadataService)ExoContainerContext.getService(MetadataService.class);
        }
        return this.metadataService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    private List<String> toList(String permissions) {
        return StringUtils.isBlank((CharSequence)permissions) ? Collections.emptyList() : Arrays.stream(permissions.substring(1, permissions.length() - 1).split(", ")).filter(StringUtils::isNotBlank).toList();
    }
}

