/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.plugin.CategoryPlugin;
import io.meeds.social.category.plugin.DefaultCategoryPlugin;
import io.meeds.social.category.service.CategoryPluginService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryPluginServiceImpl
implements CategoryPluginService {
    @Autowired
    private PortalContainer container;
    @Autowired(required=false)
    private List<CategoryPlugin> categoryPlugins;
    private Map<String, CategoryPlugin> categoryPluginsByType = new HashMap<String, CategoryPlugin>();

    public void addPlugin(CategoryPlugin categoryPlugin) {
        if (!(this.categoryPlugins instanceof ArrayList)) {
            this.categoryPlugins = this.categoryPlugins == null ? new ArrayList<CategoryPlugin>() : new ArrayList<CategoryPlugin>(this.categoryPlugins);
        }
        this.categoryPlugins.add(categoryPlugin);
    }

    public CategoryPlugin getCategoryPlugin(String objectType) {
        return this.categoryPluginsByType.computeIfAbsent(objectType, t -> this.categoryPlugins.stream().filter(c -> c.getType().equals(t)).findFirst().orElseGet(() -> new DefaultCategoryPlugin(this.container, objectType)));
    }

    public boolean canEdit(String objectType, String objectId, String username) {
        return this.getCategoryPlugin(objectType).canEdit(objectId, username);
    }

    public List<Long> getCategoryIds(String objectType, long spaceId) {
        return this.getCategoryPlugin(objectType).getCategoryIds(spaceId);
    }

    public CategoryObject getObject(CategoryObject object) {
        return this.getCategoryPlugin(object.getType()).getObject(object);
    }
}

