/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.richeditor;

import io.meeds.social.richeditor.RichEditorConfiguration;
import io.meeds.social.richeditor.RichEditorConfigurationPlugin;
import io.meeds.social.richeditor.RichEditorConfigurationService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RichEditorConfigurationServiceImpl
implements RichEditorConfigurationService {
    private static final Log LOG = ExoLogger.getLogger(RichEditorConfigurationServiceImpl.class);
    public static final String ALL_INSTANCES_KEY = "";
    private ConfigurationManager configurationManager;
    private Map<String, List<RichEditorConfiguration>> configurationFilesByType = new HashMap<String, List<RichEditorConfiguration>>();
    private final FutureExoCache<String, String, Object> configurationContentFutureCache;
    private final ExoCache<String, String> configurationContentCache;

    public RichEditorConfigurationServiceImpl(CacheService cacheService, ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.configurationContentCache = cacheService.getCacheInstance("social.richEditorConfiguration");
        this.configurationContentFutureCache = new FutureExoCache((Loader)new Loader<String, String, Object>(){

            public String retrieve(Object context, String instanceType) throws Exception {
                return RichEditorConfigurationServiceImpl.this.appendFilesContent(instanceType);
            }
        }, this.configurationContentCache);
        if (PropertyManager.isDevelopping()) {
            this.configurationContentCache.setMaxSize(0);
        }
    }

    public String getRichEditorConfiguration(String instanceType) {
        if (StringUtils.isBlank((CharSequence)instanceType)) {
            instanceType = ALL_INSTANCES_KEY;
        }
        return (String)this.configurationContentFutureCache.get(null, (Object)instanceType);
    }

    public void addPlugin(RichEditorConfigurationPlugin plugin) {
        List richEditorConfigurations = plugin.getRichEditorConfigurations();
        if (richEditorConfigurations != null) {
            richEditorConfigurations.forEach(richEditorConfiguration -> {
                String instanceType = richEditorConfiguration.getInstanceType();
                this.configurationFilesByType.computeIfAbsent(StringUtils.isBlank((CharSequence)instanceType) ? ALL_INSTANCES_KEY : instanceType, key -> new ArrayList()).addAll(richEditorConfigurations);
            });
        }
    }

    protected String appendFilesContent(String instanceType) {
        StringBuilder fileContent = new StringBuilder();
        this.appendFilesContent(fileContent, ALL_INSTANCES_KEY);
        if (StringUtils.isNotBlank((CharSequence)instanceType)) {
            this.appendFilesContent(fileContent, instanceType);
        }
        return fileContent.toString();
    }

    private void appendFilesContent(StringBuilder fileContent, String instanceType) {
        List<RichEditorConfiguration> richEditorConfigurations = this.configurationFilesByType.get(instanceType);
        if (CollectionUtils.isNotEmpty(richEditorConfigurations)) {
            this.appendFilesContent(fileContent, richEditorConfigurations);
        }
    }

    private void appendFilesContent(StringBuilder fileContent, List<RichEditorConfiguration> richEditorConfigurations) {
        richEditorConfigurations.forEach(richEditorConfiguration -> {
            try {
                InputStream is = this.configurationManager.getInputStream(richEditorConfiguration.getFilePath());
                String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                content = content.replace("${", "@JSProp{");
                content = content.replace("@JVMProp", "$");
                content = Deserializer.resolveVariables((String)content);
                content = content.replace("@JSProp{", "${");
                fileContent.append(content).append("\n");
            }
            catch (Exception e) {
                LOG.warn("Error retrieving Rich Editor file content from path {}", new Object[]{richEditorConfiguration.getFilePath(), e});
            }
        });
    }
}

