/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.translation;

import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpaceTemplateTranslationPlugin
extends TranslationPlugin {
    public static final String OBJECT_TYPE = "spaceTemplate";
    public static final String NAME_FIELD_NAME = "name";
    public static final String DESCRIPTION_FIELD_NAME = "description";
    @Autowired
    protected SpaceTemplateService spaceTemplateService;
    @Autowired
    protected TranslationService translationService;

    @PostConstruct
    public void init() {
        this.translationService.addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(String templateId, String username) throws ObjectNotFoundException {
        return this.spaceTemplateService.canManageTemplates(username);
    }

    public boolean hasAccessPermission(String templateId, String username) throws ObjectNotFoundException {
        long id = Long.parseLong(templateId);
        if (this.spaceTemplateService.getSpaceTemplate(id) == null) {
            throw new ObjectNotFoundException(String.format("Space Template with id %s not found", templateId));
        }
        return this.spaceTemplateService.canViewTemplate(id, username);
    }

    public long getAudienceId(String templateId) {
        return 0L;
    }

    public long getSpaceId(String templateId) {
        return 0L;
    }
}

