/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profileproperty;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profileproperty.ProfilePropertyDatabaseInitializer;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.profileproperty.storage.ProfileSettingStorage;
import org.picocontainer.Startable;

public class ProfilePropertyServiceImpl
implements ProfilePropertyService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ProfilePropertyServiceImpl.class);
    private final ProfileSettingStorage profileSettingStorage;
    private final SettingService settingService;
    private final IndexingService indexingService;
    private final ListenerService listenerService;
    private final TranslationService translationService;
    private static final String SYNCHRONIZED_DISABLED_PROPERTIES = "synchronizationDisabledProperties";
    private static final String UNHIDDENABLE_PROPERTIES_PARAM = "unHiddenableProperties";
    private static final String EXCLUDED_QUICK_SEARCH_PROPERTIES_PARAM = "excludedQuickSearchProperties";
    private static final String EXCLUDED_ANALYTICS_INDEX_PROPERTIES = "excludedAnalyticsIndexProperties";
    private static final Scope HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE = Scope.APPLICATION.id("ProfilePropertySettings");
    private static final String HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY = "HiddenProfilePropertySettings";
    private static final String PROFILE_PROPERTY_FIELD_NAME = "optionValue";
    private static final String PROFILE_PROPERTY_OBJECT_TYPE = "propertySettingOption";
    protected List<ProfilePropertyDatabaseInitializer> profielPropertyPlugins = new ArrayList<ProfilePropertyDatabaseInitializer>();
    private List<String> synchronizedGroupDisabledProperties = new ArrayList<String>();
    private List<String> nonHiddenableProps = new ArrayList<String>();
    private List<String> excludedQuickSearchProps = new ArrayList<String>();
    private List<String> excludedAnalyticsIndexProps = new ArrayList<String>();
    private static final String USER_CARD_SETTINGS = "UserCardSettings";

    public ProfilePropertyServiceImpl(InitParams params, ProfileSettingStorage profileSettingStorage, SettingService settingService, IndexingService indexingService, ListenerService listenerService, TranslationService translationService) {
        this.profileSettingStorage = profileSettingStorage;
        this.settingService = settingService;
        this.indexingService = indexingService;
        this.listenerService = listenerService;
        this.translationService = translationService;
        if (params != null) {
            try {
                this.synchronizedGroupDisabledProperties = Arrays.asList(params.getValueParam(SYNCHRONIZED_DISABLED_PROPERTIES).getValue().split(","));
                this.nonHiddenableProps = Arrays.asList(params.getValueParam(UNHIDDENABLE_PROPERTIES_PARAM).getValue().split(","));
                this.excludedQuickSearchProps = Arrays.asList(params.getValueParam(EXCLUDED_QUICK_SEARCH_PROPERTIES_PARAM).getValue().split(","));
                this.excludedAnalyticsIndexProps = Arrays.asList(params.getValueParam(EXCLUDED_ANALYTICS_INDEX_PROPERTIES).getValue().split(","));
            }
            catch (Exception e) {
                LOG.warn((Object)"List of disabled properties for synchronization not provided, all properties can be synchronized! ");
            }
        }
    }

    public List<ProfilePropertySetting> getPropertySettings() {
        return this.profileSettingStorage.getPropertySettings();
    }

    public List<ProfilePropertySetting> getSynchronizedPropertySettings() {
        return this.profileSettingStorage.getSynchronizedPropertySettings();
    }

    public ProfilePropertySetting getProfileSettingByName(String name) {
        return this.profileSettingStorage.findProfileSettingByName(name);
    }

    public List<String> getExcludedAnalyticsIndexProperties() {
        return this.excludedAnalyticsIndexProps;
    }

    public ProfilePropertySetting getProfileSettingById(Long id) {
        return this.profileSettingStorage.getProfileSettingById(id);
    }

    public List<String> getUnhiddenableProfileProperties() {
        return this.nonHiddenableProps;
    }

    public List<String> getExcludedQuickSearchProperties() {
        return this.excludedQuickSearchProps;
    }

    public boolean isPropertySettingHiddenable(Long id) {
        return this.isPropertySettingHiddenable(this.getProfileSettingById(id));
    }

    public ProfilePropertySetting createPropertySetting(ProfilePropertySetting profilePropertySetting) throws ObjectAlreadyExistsException {
        this.validatePropertySetting(profilePropertySetting);
        ProfilePropertySetting storedProfilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        if (storedProfilePropertySetting != null) {
            throw new ObjectAlreadyExistsException((Object)storedProfilePropertySetting, "A profile property with the provided name already exists.");
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        profilePropertySetting.setUpdated(Long.valueOf(System.currentTimeMillis()));
        storedProfilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        this.savePropertyOptionsTranslations(storedProfilePropertySetting, profilePropertySetting.getPropertyOptions(), false);
        if (storedProfilePropertySetting.getOrder() == null) {
            storedProfilePropertySetting.setOrder(storedProfilePropertySetting.getId());
            storedProfilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(storedProfilePropertySetting, false);
        }
        try {
            this.listenerService.broadcast("profile-property-setting-created", (Object)this, (Object)storedProfilePropertySetting);
        }
        catch (Exception e) {
            LOG.error("An error occurred while broadcasting the creation event for the property setting '{}'.", new Object[]{storedProfilePropertySetting.getPropertyName(), e});
        }
        return storedProfilePropertySetting;
    }

    public void updatePropertySetting(ProfilePropertySetting profilePropertySetting) {
        ProfilePropertySetting createdProfilePropertySetting;
        this.validatePropertySetting(profilePropertySetting);
        if (profilePropertySetting.isHiddenbale() && this.getUnhiddenableProfileProperties().contains(profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException(String.format("%s cannot be hidden", profilePropertySetting.getPropertyName()));
        }
        if (profilePropertySetting.isMultiValued() && this.isUserCardFieldSettings(profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException(String.format("%s cannot be multivalued", profilePropertySetting.getPropertyName()));
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        if ((createdProfilePropertySetting = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getId())) != null && this.isDefaultProperties(profilePropertySetting)) {
            profilePropertySetting.setMultiValued(createdProfilePropertySetting.isMultiValued());
        }
        if (createdProfilePropertySetting != null) {
            profilePropertySetting.setPropertyType(createdProfilePropertySetting.getPropertyType());
        }
        profilePropertySetting.setUpdated(Long.valueOf(System.currentTimeMillis()));
        ProfilePropertySetting updatedPropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
        this.savePropertyOptionsTranslations(updatedPropertySetting, profilePropertySetting.getPropertyOptions(), true);
        try {
            this.listenerService.broadcast("profile-property-setting-updated", (Object)this, (Object)updatedPropertySetting);
        }
        catch (Exception e) {
            LOG.error("An error occurred when broadcasting the update event of the property setting {}", new Object[]{updatedPropertySetting.getPropertyName(), e});
        }
    }

    public void deleteProfilePropertySetting(Long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Profile Property Setting Technical Identifier is mandatory");
        }
        this.profileSettingStorage.deleteProfilePropertySetting(id);
    }

    public boolean isGroupSynchronizedEnabledProperty(Long id) {
        return this.isGroupSynchronizedEnabledProperty(this.getProfileSettingById(id));
    }

    public List<String> getPropertySettingNames() {
        return this.getPropertySettings().stream().map(ProfilePropertySetting::getPropertyName).toList();
    }

    public void hidePropertySetting(long userIdentityId, long profilePropertyId) {
        List<Long> hiddenProperties = this.getHiddenProfilePropertyIds(userIdentityId);
        hiddenProperties.remove(profilePropertyId);
        hiddenProperties.add(profilePropertyId);
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY, SettingValue.create((String)hiddenProperties.toString()));
        this.indexingService.reindex("profile", String.valueOf(userIdentityId));
    }

    public void showPropertySetting(long userIdentityId, long profilePropertyId) {
        List<Long> hiddenProperties = this.getHiddenProfilePropertyIds(userIdentityId);
        hiddenProperties.remove(profilePropertyId);
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY, SettingValue.create((String)hiddenProperties.toString()));
        this.indexingService.reindex("profile", String.valueOf(userIdentityId));
    }

    public List<Long> getHiddenProfilePropertyIds(long userIdentityId) {
        List<Long> hiddenProfileProperties = new ArrayList<Long>();
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY);
        if (settingValue == null) {
            return hiddenProfileProperties;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            hiddenProfileProperties = (List)mapper.readValue(settingValue.getValue().toString(), (TypeReference)new TypeReference<ArrayList<Long>>(this){});
        }
        catch (Exception e) {
            LOG.error("Error while parsing hidden properties setting of user: {}", new Object[]{userIdentityId, e});
        }
        return hiddenProfileProperties;
    }

    public void start() {
        for (ProfilePropertyDatabaseInitializer plugin : this.profielPropertyPlugins) {
            try {
                plugin.init(this);
            }
            catch (Exception ex) {
                LOG.error("Failed start Profile properties Service , probably because of configuration error. Error occurs when initializing properties for {}", new Object[]{((Object)((Object)plugin)).getClass().getName(), ex});
            }
        }
    }

    public void stop() {
    }

    public void addProfilePropertyPlugin(ComponentPlugin profilePropertyInitPlugin) {
        this.profielPropertyPlugins.add((ProfilePropertyDatabaseInitializer)profilePropertyInitPlugin);
    }

    public boolean isDefaultProperties(ProfilePropertySetting propertySetting) {
        for (ProfilePropertyDatabaseInitializer plugin : this.profielPropertyPlugins) {
            if (plugin.getConfig().getProfileProperties() == null || plugin.getConfig().getProfileProperties().isEmpty() || !plugin.getConfig().getProfileProperties().stream().anyMatch(profileProperty -> profileProperty.getPropertyName().equals(propertySetting.getPropertyName()))) continue;
            return true;
        }
        return false;
    }

    private void validatePropertySetting(ProfilePropertySetting profilePropertySetting) {
        if (profilePropertySetting == null) {
            throw new IllegalArgumentException("Profile property setting object is mandatory.");
        }
        if (StringUtils.isBlank((CharSequence)profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException("Profile property name is mandatory.");
        }
        if (profilePropertySetting.isDropdownList() && !"text".equals(profilePropertySetting.getPropertyType())) {
            throw new IllegalArgumentException("Only text properties can be dropdown lists.");
        }
    }

    private void savePropertyOptionsTranslations(ProfilePropertySetting savedProfilePropertySetting, List<ProfilePropertyOption> newOptions, boolean update) {
        if (!savedProfilePropertySetting.isDropdownList()) {
            return;
        }
        List<ProfilePropertyOption> savedOptions = this.profileSettingStorage.getProfilePropertyOptions(savedProfilePropertySetting.getId(), 0, 0);
        for (int i = 0; i < savedOptions.size(); ++i) {
            ProfilePropertyOption newOption;
            ProfilePropertyOption savedOption = savedOptions.get(i);
            ProfilePropertyOption profilePropertyOption = newOption = i < newOptions.size() ? newOptions.get(i) : null;
            if (savedOption == null || newOption == null) continue;
            try {
                TranslationField translationField = this.translationService.getTranslationField(PROFILE_PROPERTY_OBJECT_TYPE, savedOption.getId().longValue(), PROFILE_PROPERTY_FIELD_NAME);
                Map<Locale, String> translations = newOption.getTranslations().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue));
                this.translationService.saveTranslationLabels(PROFILE_PROPERTY_OBJECT_TYPE, savedOption.getId().longValue(), PROFILE_PROPERTY_FIELD_NAME, translations);
                if (!update || translationField == null || translationField.getLabels().equals(translations)) continue;
                this.listenerService.broadcast("property_options_updated", (Object)newOption, (Object)translationField.getLabels());
                continue;
            }
            catch (Exception e) {
                LOG.error("Error while saving translation labels for profile property option {}", new Object[]{savedOption.getId(), e});
            }
        }
    }

    private boolean isPropertySettingHiddenable(ProfilePropertySetting propertySetting) {
        return propertySetting != null && !this.nonHiddenableProps.contains(propertySetting.getPropertyName()) && !propertySetting.isHasChildProperties() && propertySetting.isHiddenbale();
    }

    private boolean isGroupSynchronizedEnabledProperty(ProfilePropertySetting profilePropertySetting) {
        if (profilePropertySetting == null || this.synchronizedGroupDisabledProperties.contains(profilePropertySetting.getPropertyName())) {
            return false;
        }
        if (profilePropertySetting.getParentId() != null && profilePropertySetting.getParentId() > 0L) {
            ProfilePropertySetting parent = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getParentId());
            return parent == null || !this.synchronizedGroupDisabledProperties.contains(parent.getPropertyName());
        }
        return true;
    }

    public boolean isUserCardFieldSettings(String propertyName) {
        SettingValue userCardFirstFieldSetting = this.settingService.get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardFirstFieldSetting");
        SettingValue userCardSecondFieldSetting = this.settingService.get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardSecondFieldSetting");
        SettingValue userCardThirdFieldSetting = this.settingService.get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardThirdFieldSetting");
        return Stream.of(userCardFirstFieldSetting, userCardSecondFieldSetting, userCardThirdFieldSetting).filter(Objects::nonNull).anyMatch(setting -> propertyName.equals(setting.getValue()));
    }
}

