/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.portlet.PortletMode;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Text;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.state.ContextualPropertyManager;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.module.ModuleRegistry;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pc.ExoPortletState;
import org.exoplatform.portal.portlet.PortletExceptionHandleService;
import org.exoplatform.portal.webui.application.ExoPortletInstanceContext;
import org.exoplatform.portal.webui.application.ExoPortletInvocationContext;
import org.exoplatform.portal.webui.application.ExoServerContext;
import org.exoplatform.portal.webui.application.ExoUserContext;
import org.exoplatform.portal.webui.application.ModelAdapter;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIPortletActionListener;
import org.exoplatform.portal.webui.application.UIPortletLifecycle;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractRequestContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractWindowContext;
import org.w3c.dom.Element;

@ComponentConfig(lifecycle=UIPortletLifecycle.class, template="system:/groovy/portal/webui/application/UIPortlet.gtmpl", events={@EventConfig(listeners={UIPortletActionListener.RenderActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortletActionListener.ChangePortletModeActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortletActionListener.ChangeWindowStateActionListener.class}, csrfCheck=false), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessActionActionListener.class}, csrfCheck=false), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ServeResourceActionListener.class}, csrfCheck=false), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessEventsActionListener.class}, csrfCheck=false)})
public class UIPortlet
extends UIApplication {
    protected static final Log LOG = ExoLogger.getLogger((String)"portal:UIPortlet");
    public static final String DEFAULT_THEME = "Default:DefaultTheme::Vista:VistaTheme::Mac:MacTheme";
    public static final String JAVASCRIPT_DEPENDENCY = "org.gatein.javascript.dependency";
    private static final AbstractPortalContext PORTAL_CONTEXT = new AbstractPortalContext(Collections.singletonMap("javax.portlet.markup.head.element.support", "true"));
    private String storageId;
    private String storageName;
    private ModelAdapter adapter;
    private Portlet producedOfferedPortlet;
    private PortletContext producerOfferedPortletContext;
    private LocalizedString displayName;
    private PortletState state;
    private String applicationId;
    private String theme;
    private String portletStyle;
    private List<String> supportModes;
    private List<QName> supportedProcessingEvents;
    private List<QName> supportedPublishingEvents;
    private Map<QName, String> supportedPublicParams;
    private StateString navigationalState;
    private String configuredTitle;
    private String cssClass;
    private boolean showPortletMode;
    private static final ThreadLocal<UIPortlet> currentPortlet = new ThreadLocal();

    @Override
    public String getId() {
        return this.storageId == null ? super.getId() : this.storageId;
    }

    public String getStorageName() {
        if (this.storageName == null) {
            this.storageName = UUID.randomUUID().toString();
        }
        return this.storageName;
    }

    public String getWindowId() {
        return this.getStorageName();
    }

    public String getSkinId() {
        return this.applicationId;
    }

    public boolean getShowPortletMode() {
        return this.showPortletMode;
    }

    public String getTheme() {
        if (this.theme == null || this.theme.trim().length() < 1) {
            return DEFAULT_THEME;
        }
        return this.theme;
    }

    public PortletMode getCurrentPortletMode() {
        String maximizedPortletMode = this.getMaximizedPortletMode();
        if (StringUtils.isBlank((CharSequence)maximizedPortletMode)) {
            return PortletRequestContext.getCurrentPortletMode();
        }
        if (maximizedPortletMode.equals(PortletMode.VIEW.toString())) {
            return PortletMode.VIEW;
        }
        if (maximizedPortletMode.equals(PortletMode.HELP.toString())) {
            return PortletMode.HELP;
        }
        if (maximizedPortletMode.equals(PortletMode.EDIT.toString())) {
            return PortletMode.EDIT;
        }
        return new PortletMode(maximizedPortletMode);
    }

    public void setCurrentPortletMode(PortletMode mode) {
        PortletRequestContext.setCurrentPortletMode(mode);
    }

    public javax.portlet.WindowState getCurrentWindowState() {
        return PortletRequestContext.getCurrentWindowState();
    }

    public void setCurrentWindowState(javax.portlet.WindowState state) {
        PortletRequestContext.setCurrentWindowState(state);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet != null) {
                PortletInfo info = portlet.getInfo();
                MetaInfo meta = info.getMeta();
                this.displayName = meta.getMetaValue("display-name");
                String value = null;
                if (this.displayName != null) {
                    org.exoplatform.web.application.RequestContext i = org.exoplatform.web.application.RequestContext.getCurrentInstance();
                    Locale locale = i.getLocale();
                    value = this.displayName.getString(locale, true);
                }
                if (value == null || value.length() == 0) {
                    value = info.getName();
                }
                return value;
            }
            return "";
        }
        org.exoplatform.web.application.RequestContext i = org.exoplatform.web.application.RequestContext.getCurrentInstance();
        Locale locale = i.getLocale();
        String value = this.displayName.getString(locale, true);
        if (ParameterValidation.isNullOrEmpty((String)value)) {
            Portlet portlet = this.getProducedOfferedPortlet();
            PortletInfo info = portlet.getInfo();
            value = info.getName();
        }
        return value;
    }

    public List<String> getSupportModes() {
        if (this.supportModes != null) {
            return this.supportModes;
        }
        this.supportModes = new ArrayList<String>();
        Portlet portlet = this.getProducedOfferedPortlet();
        if (portlet == null) {
            return this.supportModes;
        }
        Set modes = portlet.getInfo().getCapabilities().getModes(MediaType.create((String)"text/html"));
        for (ModeInfo mode : modes) {
            this.supportModes.add(mode.getModeName());
        }
        if (!this.supportModes.isEmpty()) {
            this.supportModes.remove("view");
        }
        return this.supportModes;
    }

    public List<String> getPublicRenderParamNames() {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        ArrayList<String> publicParamsSupportedByPortlet = new ArrayList<String>();
        if (publicParams != null) {
            Set<String> keys = publicParams.keySet();
            for (String key : keys) {
                if (!this.supportsPublicParam(key)) continue;
                publicParamsSupportedByPortlet.add(key);
            }
            return publicParamsSupportedByPortlet;
        }
        return new ArrayList<String>();
    }

    public Map<String, String[]> getPublicParameters(Map<String, String[]> portletParameters) {
        HashMap<String, String[]> publicParamsMap = new HashMap<String, String[]>();
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        Set<String> allPublicParamsNames = publicParams.keySet();
        List<String> supportedPublicParamNames = this.getPublicRenderParamNames();
        for (String oneOfAllParams : allPublicParamsNames) {
            if (!supportedPublicParamNames.contains(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, publicParams.get(oneOfAllParams));
            if (portletParameters == null || !portletParameters.containsKey(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, portletParameters.get(oneOfAllParams));
            publicParams.put(oneOfAllParams, portletParameters.get(oneOfAllParams));
        }
        if (this.supportedPublicParams != null && MapUtils.isNotEmpty(portletParameters) && allPublicParamsNames.isEmpty()) {
            for (QName qName : this.supportedPublicParams.keySet()) {
                String prpId = this.supportsPublicParam(qName);
                if (prpId == null || !portletParameters.containsKey(prpId)) continue;
                publicParamsMap.put(prpId, portletParameters.get(prpId));
                publicParams.put(prpId, portletParameters.get(prpId));
            }
        }
        ContextualPropertyManager propertyManager = this.getApplicationComponent(ContextualPropertyManager.class);
        Map<QName, String[]> exposedPortalState = propertyManager.getProperties(this);
        for (QName prpQName : exposedPortalState.keySet()) {
            String prpId = this.supportsPublicParam(prpQName);
            if (prpId == null) continue;
            publicParamsMap.put(prpId, exposedPortalState.get(prpQName));
        }
        return publicParamsMap;
    }

    public Map<String, String[]> getPublicParameters() {
        return this.getPublicParameters(null);
    }

    public <I extends PortletInvocation> I create(Class<I> type, PortalRequestContext prc) throws Exception {
        PortletInvocation invocation;
        ExoPortletInvocationContext pic = new ExoPortletInvocationContext(prc, this);
        HttpServletRequest servletRequest = prc.getRequest();
        HashMap<String, String[]> allParams = new HashMap<String, String[]>();
        allParams.putAll(prc.getPortletParameters());
        allParams.putAll(this.getPublicParameters());
        allParams.remove("navigationalstate");
        if (type.equals(ActionInvocation.class)) {
            ActionInvocation actionInvocation = new ActionInvocation((PortletInvocationContext)pic);
            actionInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String interactionState = servletRequest.getParameter("interactionstate");
            if (interactionState != null) {
                actionInvocation.setInteractionState(StateString.create((String)interactionState));
                allParams.remove("interactionstate");
            }
            actionInvocation.setForm(allParams);
            invocation = (PortletInvocation)type.cast(actionInvocation);
        } else if (type.equals(ResourceInvocation.class)) {
            String resourceState;
            ResourceInvocation resourceInvocation = new ResourceInvocation((PortletInvocationContext)pic);
            resourceInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String resourceId = servletRequest.getParameter("portal:resourceID");
            if (!ParameterValidation.isNullOrEmpty((String)resourceId)) {
                resourceInvocation.setResourceId(resourceId);
            } else if (!ParameterValidation.isNullOrEmpty((String)prc.getRequestParameter("portal:resourceID"))) {
                resourceInvocation.setResourceId(prc.getRequestParameter("portal:resourceID"));
            }
            String cachability = servletRequest.getParameter("portal:cacheLevel");
            if (!ParameterValidation.isNullOrEmpty((String)cachability)) {
                resourceInvocation.setCacheLevel(CacheLevel.create((String)cachability.toUpperCase(Locale.ENGLISH)));
            }
            if (!ParameterValidation.isNullOrEmpty((String)(resourceState = servletRequest.getParameter("resourcestate")))) {
                resourceInvocation.setResourceState(StateString.create((String)resourceState));
            }
            allParams.remove("resourcestate");
            resourceInvocation.setForm(allParams);
            invocation = (PortletInvocation)type.cast(resourceInvocation);
        } else if (type.equals(EventInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new EventInvocation((PortletInvocationContext)pic));
        } else if (type.equals(RenderInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new RenderInvocation((PortletInvocationContext)pic));
        } else {
            throw new AssertionError();
        }
        invocation.setRequest(servletRequest);
        invocation.setResponse(prc.getResponse());
        invocation.setNavigationalState(this.navigationalState);
        invocation.setPublicNavigationalState(this.getPublicParameters(prc.getPortletParameters()));
        invocation.setMode(Mode.create((String)this.getCurrentPortletMode().toString()));
        invocation.setWindowState(WindowState.create((String)this.getCurrentWindowState().toString()));
        StatefulPortletContext<ExoPortletState> preferencesPortletContext = this.getPortletContext();
        if (preferencesPortletContext == null) {
            return null;
        }
        UserProfile userProfile = (UserProfile)prc.getAttribute("PortalUserProfile");
        Cookie[] cookies = servletRequest.getCookies();
        AbstractClientContext clientContext = cookies != null ? new AbstractClientContext(servletRequest, Arrays.asList(cookies)) : new AbstractClientContext(servletRequest);
        invocation.setClientContext((ClientContext)clientContext);
        ExoPortletInstanceContext instanceContext = new ExoPortletInstanceContext(preferencesPortletContext.getId());
        invocation.setTarget(preferencesPortletContext);
        invocation.setInstanceContext((InstanceContext)instanceContext);
        invocation.setServerContext((ServerContext)new ExoServerContext(servletRequest, prc.getResponse()));
        invocation.setUserContext((UserContext)new ExoUserContext(servletRequest, userProfile));
        invocation.setWindowContext((WindowContext)new AbstractWindowContext(this.getStorageName()));
        invocation.setPortalContext((PortalContext)PORTAL_CONTEXT);
        invocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(servletRequest));
        return (I)invocation;
    }

    public void update(PropertyChange ... changes) throws Exception {
        StatefulPortletContext<ExoPortletState> portletContext = this.getPortletContext();
        PortletInvoker portletInvoker = this.getApplicationComponent(PortletInvoker.class);
        StatefulPortletContext updatedCtx = (StatefulPortletContext)portletInvoker.setProperties(portletContext, changes);
        ExoPortletState updateState = (ExoPortletState)updatedCtx.getState();
        this.update(updateState);
    }

    public PortletState getState() {
        return this.state;
    }

    public void setState(PortletState state) {
        if (state != null) {
            try {
                PortletInvoker portletInvoker = this.getApplicationComponent(PortletInvoker.class);
                LayoutService layoutService = this.getApplicationComponent(LayoutService.class);
                String applicationId = layoutService.getId(state.getApplicationState());
                ModelAdapter adapter = ModelAdapter.getAdapter();
                PortletContext producerOfferedPortletContext = adapter.getProducerOfferedPortletContext(applicationId);
                ModuleRegistry moduleRegistry = this.getApplicationComponent(ModuleRegistry.class);
                if (moduleRegistry.isPortletActive(applicationId)) {
                    try {
                        this.producedOfferedPortlet = portletInvoker.getPortlet(producerOfferedPortletContext);
                    }
                    catch (Exception e) {
                        this.producedOfferedPortlet = null;
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.adapter = adapter;
                this.producerOfferedPortletContext = producerOfferedPortletContext;
                this.applicationId = applicationId;
            }
            catch (NoSuchDataException e) {
                LOG.error((Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.adapter = null;
            this.producedOfferedPortlet = null;
            this.producerOfferedPortletContext = null;
            this.applicationId = null;
        }
        this.state = state;
    }

    public org.exoplatform.portal.pom.spi.portlet.Portlet getPreferences() throws Exception {
        org.exoplatform.web.application.RequestContext context = org.exoplatform.web.application.RequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getState(container, this.state.getApplicationState());
    }

    public StatefulPortletContext<ExoPortletState> getPortletContext() throws Exception {
        org.exoplatform.web.application.RequestContext context = org.exoplatform.web.application.RequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getPortletContext(container, this.applicationId, this.state.getApplicationState());
    }

    public void update(ExoPortletState updateState) throws Exception {
        org.exoplatform.web.application.RequestContext context = org.exoplatform.web.application.RequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        this.state.setApplicationState(this.adapter.update(container, updateState, this.state.getApplicationState()));
        this.setState(this.state);
    }

    public ExoPortletState getModifiedState(PortletContext modifiedContext) throws Exception {
        return this.adapter.getStateFromModifiedContext((PortletContext)this.getPortletContext(), modifiedContext);
    }

    public ExoPortletState getClonedState(PortletContext clonedContext) throws Exception {
        return this.adapter.getstateFromClonedContext((PortletContext)this.getPortletContext(), clonedContext);
    }

    public static UIPortlet getCurrentUIPortlet() {
        return currentPortlet.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletInvoker portletInvoker = this.getApplicationComponent(PortletInvoker.class);
        currentPortlet.set(this);
        try {
            PortletInvocationResponse portletInvocationResponse = portletInvoker.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            currentPortlet.remove();
        }
    }

    public Text generateRenderMarkup(PortletInvocationResponse pir, WebuiRequestContext context) {
        PortalRequestContext prcontext = PortalRequestContext.getCurrentInstance();
        Text markup = null;
        if (pir instanceof FragmentResponse) {
            FragmentResponse fragmentResponse = (FragmentResponse)pir;
            switch (fragmentResponse.getType()) {
                case 1: {
                    markup = Text.create((String)fragmentResponse.getContent());
                    break;
                }
                case 2: {
                    markup = Text.create((byte[])fragmentResponse.getBytes(), (Charset)StandardCharsets.UTF_8);
                    break;
                }
                default: {
                    markup = Text.create((String)"");
                }
            }
            this.setConfiguredTitle(fragmentResponse.getTitle());
            if (fragmentResponse.getProperties() != null) {
                MultiValuedPropertyMap markupHeaders;
                List markupElements;
                if (fragmentResponse.getProperties().getTransportHeaders() != null) {
                    JavascriptManager jsMan = context.getJavascriptManager();
                    MultiValuedPropertyMap transportHeaders = fragmentResponse.getProperties().getTransportHeaders();
                    for (String key : transportHeaders.keySet()) {
                        if (JAVASCRIPT_DEPENDENCY.equals(key)) {
                            for (String value : transportHeaders.getValues(key)) {
                                jsMan.require(value);
                            }
                            continue;
                        }
                        for (String value : transportHeaders.getValues(key)) {
                            prcontext.getResponse().setHeader(key, value);
                        }
                    }
                }
                if (fragmentResponse.getProperties().getCookies() != null) {
                    List cookies = fragmentResponse.getProperties().getCookies();
                    for (Cookie cookie : cookies) {
                        prcontext.getResponse().addCookie(cookie);
                    }
                }
                if (fragmentResponse.getProperties().getMarkupHeaders() != null && (markupElements = (markupHeaders = fragmentResponse.getProperties().getMarkupHeaders()).getValues("javax.portlet.markup.head.element")) != null) {
                    for (Element element : markupElements) {
                        if (!context.useAjax() && "title".equalsIgnoreCase(element.getNodeName()) && element.getFirstChild() != null) {
                            String title = element.getFirstChild().getNodeValue();
                            prcontext.getRequest().setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)title);
                            continue;
                        }
                        prcontext.addExtraMarkupHeader(element, this.getId());
                    }
                }
            }
        } else {
            PortletContainerException pcException;
            if (pir instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)pir;
                pcException = new PortletContainerException(errorResponse.getMessage(), errorResponse.getCause());
            } else {
                pcException = new PortletContainerException("Unknown invocation response type [" + String.valueOf(pir.getClass()) + "]. Expected a FragmentResponse or an ErrorResponse");
            }
            PortletExceptionHandleService portletExceptionService = this.getApplicationComponent(PortletExceptionHandleService.class);
            if (portletExceptionService != null) {
                portletExceptionService.handle(pcException);
            }
            LOG.error("Portlet render threw an exception in page {}", new Object[]{prcontext.getRequest().getRequestURI(), pcException});
            markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError"));
        }
        return markup;
    }

    public String supportsPublicParam(QName supportedPublicParam) {
        return this.getSupportedPublicParams().get(supportedPublicParam);
    }

    public boolean supportsPublicParam(String supportedPublicParam) {
        return this.getSupportedPublicParams().values().contains(supportedPublicParam);
    }

    public boolean supportsProcessingEvent(QName name) {
        return this.getSupportedProcessingEvents().contains(name);
    }

    public boolean supportsPublishingEvent(QName name) {
        return this.getSupportedPublishingEvents().contains(name);
    }

    public Map<QName, String> getSupportedPublicParams() {
        if (this.supportedPublicParams == null) {
            if (this.producedOfferedPortlet == null) {
                this.supportedPublicParams = Collections.emptyMap();
            } else {
                Collection parameters = this.producedOfferedPortlet.getInfo().getNavigation().getPublicParameters();
                this.supportedPublicParams = parameters.stream().collect(Collectors.toMap(ParameterInfo::getName, ParameterInfo::getId));
            }
        }
        return this.supportedPublicParams;
    }

    public List<QName> getSupportedProcessingEvents() {
        if (this.supportedProcessingEvents == null) {
            Map consumedEvents;
            Portlet portlet = this.getProducedOfferedPortlet();
            this.supportedProcessingEvents = portlet == null ? Collections.emptyList() : (MapUtils.isEmpty((Map)(consumedEvents = portlet.getInfo().getEventing().getConsumedEvents())) ? Collections.emptyList() : new ArrayList(consumedEvents.keySet()));
        }
        return this.supportedProcessingEvents;
    }

    public List<QName> getSupportedPublishingEvents() {
        if (this.supportedPublishingEvents == null) {
            Map producedEvents;
            Portlet portlet = this.getProducedOfferedPortlet();
            this.supportedPublishingEvents = portlet == null ? Collections.emptyList() : (MapUtils.isEmpty((Map)(producedEvents = portlet.getInfo().getEventing().getProducedEvents())) ? Collections.emptyList() : new ArrayList(producedEvents.keySet()));
        }
        return this.supportedPublishingEvents;
    }

    public String getDisplayTitle() {
        String displayedTitle = this.getTitle();
        if (displayedTitle != null && displayedTitle.trim().length() > 0) {
            return displayedTitle;
        }
        if (this.configuredTitle != null) {
            return this.configuredTitle;
        }
        return this.getDisplayName();
    }

    private String getMaximizedPortletMode() {
        PortalRequestContext prContext = Util.getPortalRequestContext();
        HttpServletRequest req = prContext.getRequest();
        return req.getParameter("maximizedPortletMode");
    }

    @Generated
    public String getStorageId() {
        return this.storageId;
    }

    @Generated
    public ModelAdapter getAdapter() {
        return this.adapter;
    }

    @Generated
    public Portlet getProducedOfferedPortlet() {
        return this.producedOfferedPortlet;
    }

    @Generated
    public PortletContext getProducerOfferedPortletContext() {
        return this.producerOfferedPortletContext;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getPortletStyle() {
        return this.portletStyle;
    }

    @Generated
    public StateString getNavigationalState() {
        return this.navigationalState;
    }

    @Generated
    public String getConfiguredTitle() {
        return this.configuredTitle;
    }

    @Generated
    public String getCssClass() {
        return this.cssClass;
    }

    @Generated
    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    @Generated
    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    @Generated
    public void setAdapter(ModelAdapter adapter) {
        this.adapter = adapter;
    }

    @Generated
    public void setProducedOfferedPortlet(Portlet producedOfferedPortlet) {
        this.producedOfferedPortlet = producedOfferedPortlet;
    }

    @Generated
    public void setProducerOfferedPortletContext(PortletContext producerOfferedPortletContext) {
        this.producerOfferedPortletContext = producerOfferedPortletContext;
    }

    @Generated
    public void setDisplayName(LocalizedString displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Generated
    public void setPortletStyle(String portletStyle) {
        this.portletStyle = portletStyle;
    }

    @Generated
    public void setSupportModes(List<String> supportModes) {
        this.supportModes = supportModes;
    }

    @Generated
    public void setSupportedProcessingEvents(List<QName> supportedProcessingEvents) {
        this.supportedProcessingEvents = supportedProcessingEvents;
    }

    @Generated
    public void setSupportedPublishingEvents(List<QName> supportedPublishingEvents) {
        this.supportedPublishingEvents = supportedPublishingEvents;
    }

    @Generated
    public void setSupportedPublicParams(Map<QName, String> supportedPublicParams) {
        this.supportedPublicParams = supportedPublicParams;
    }

    @Generated
    public void setNavigationalState(StateString navigationalState) {
        this.navigationalState = navigationalState;
    }

    @Generated
    public void setConfiguredTitle(String configuredTitle) {
        this.configuredTitle = configuredTitle;
    }

    @Generated
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Generated
    public void setShowPortletMode(boolean showPortletMode) {
        this.showPortletMode = showPortletMode;
    }
}

