/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface Promise<C> {
    public static final Promise<?> NOOP = new Promise<Object>(){

        @Override
        public void succeed(Object result) {
        }

        @Override
        public void fail(Throwable failure) {
        }
    };

    default public void succeed(C result) {
    }

    default public void fail(Throwable failure) {
    }

    default public BiConsumer<C, Throwable> complete() {
        return (r, x) -> {
            if (x == null) {
                this.succeed(r);
            } else {
                this.fail((Throwable)x);
            }
        };
    }

    public static <T> Promise<T> noop() {
        return NOOP;
    }

    public static <T> Promise<T> from(final Consumer<T> succeed, final Consumer<Throwable> fail) {
        return new Promise<T>(){

            @Override
            public void succeed(T result) {
                succeed.accept(result);
            }

            @Override
            public void fail(Throwable failure) {
                fail.accept(failure);
            }
        };
    }

    public static <T> Promise<T> complete(final BiConsumer<T, Throwable> fn) {
        return new Promise<T>(){

            @Override
            public void succeed(T result) {
                fn.accept(result, null);
            }

            @Override
            public void fail(Throwable failure) {
                fn.accept(null, failure);
            }
        };
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        @Override
        public void succeed(S result) {
            this.complete(result);
        }

        @Override
        public void fail(Throwable failure) {
            this.completeExceptionally(failure);
        }
    }
}

