/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.IndexOptions;
import org.springframework.data.elasticsearch.annotations.IndexPrefixes;
import org.springframework.data.elasticsearch.annotations.KnnIndexOptions;
import org.springframework.data.elasticsearch.annotations.KnnSimilarity;
import org.springframework.data.elasticsearch.annotations.NullValueType;
import org.springframework.data.elasticsearch.annotations.TermVector;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Documented
@Inherited
public @interface Field {
    @AliasFor(value="name")
    public String value() default "";

    @AliasFor(value="value")
    public String name() default "";

    public FieldType type() default FieldType.Auto;

    public boolean index() default true;

    public DateFormat[] format() default {DateFormat.date_optional_time, DateFormat.epoch_millis};

    public String[] pattern() default {};

    public boolean store() default false;

    public boolean fielddata() default false;

    public String searchAnalyzer() default "";

    public String analyzer() default "";

    public String normalizer() default "";

    public String[] ignoreFields() default {};

    public boolean includeInParent() default false;

    public String[] copyTo() default {};

    public int ignoreAbove() default -1;

    public boolean coerce() default true;

    public boolean docValues() default true;

    public boolean ignoreMalformed() default false;

    public IndexOptions indexOptions() default IndexOptions.none;

    public boolean indexPhrases() default false;

    public IndexPrefixes[] indexPrefixes() default {};

    public boolean norms() default true;

    public String nullValue() default "";

    public int positionIncrementGap() default -1;

    public String similarity() default "default";

    public TermVector termVector() default TermVector.none;

    public double scalingFactor() default 1.0;

    public int maxShingleSize() default -1;

    public boolean storeNullValue() default false;

    public boolean positiveScoreImpact() default true;

    public boolean enabled() default true;

    public boolean eagerGlobalOrdinals() default false;

    public NullValueType nullValueType() default NullValueType.String;

    public int dims() default -1;

    public String elementType() default "";

    public KnnSimilarity knnSimilarity() default KnnSimilarity.DEFAULT;

    public KnnIndexOptions[] knnIndexOptions() default {};

    public Dynamic dynamic() default Dynamic.INHERIT;

    public boolean excludeFromSource() default false;

    public boolean storeEmptyValue() default true;

    public String mappedTypeName() default "";
}

