/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.util.Assert;

public class GeoJsonGeometryCollection
implements GeoJson<Iterable<GeoJson<?>>> {
    public static final String TYPE = "GeometryCollection";
    private final List<GeoJson<?>> geometries = new ArrayList();

    private GeoJsonGeometryCollection(List<GeoJson<?>> geometries) {
        this.geometries.addAll(geometries);
    }

    public static GeoJsonGeometryCollection of(List<GeoJson<?>> geometries) {
        Assert.notNull(geometries, (String)"Geometries must not be null!");
        return new GeoJsonGeometryCollection(geometries);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Iterable<GeoJson<?>> getCoordinates() {
        return this.getGeometries();
    }

    public List<GeoJson<?>> getGeometries() {
        return Collections.unmodifiableList(this.geometries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonGeometryCollection that = (GeoJsonGeometryCollection)o;
        return this.geometries.equals(that.geometries);
    }

    public int hashCode() {
        return this.geometries.hashCode();
    }

    public String toString() {
        return "GeoJsonGeometryCollection{geometries=" + String.valueOf(this.geometries) + "}";
    }
}

