/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import org.apache.sis.filter.BinaryGeometryFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Envelope;

final class BinarySpatialFilter<R, G>
extends BinaryGeometryFilter<R, G> {
    private static final long serialVersionUID = -7600403345673820881L;
    private final SpatialOperatorName operatorType;

    BinarySpatialFilter(Geometries<G> geometries, Expression<? super R, ?> expression, Envelope envelope, WraparoundMethod wraparoundMethod) {
        super(geometries, expression, new LeafExpression.Transformed(geometries.toGeometry2D(envelope, wraparoundMethod), new LeafExpression.Literal(envelope)), null);
        this.operatorType = SpatialOperatorName.BBOX;
    }

    BinarySpatialFilter(SpatialOperatorName spatialOperatorName, Geometries<G> geometries, Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        super(geometries, expression, expression2, null);
        this.operatorType = spatialOperatorName;
        ArgumentChecks.ensureNonNull((String)"operatorType", (Object)((Object)spatialOperatorName));
    }

    @Override
    protected BinaryGeometryFilter<R, G> recreate(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new BinarySpatialFilter(this.operatorType, BinarySpatialFilter.getGeometryLibrary(this.expression1), expression, expression2);
    }

    public SpatialOperatorName getOperatorType() {
        return this.operatorType;
    }

    public Expression<? super R, ?> getOperand1() {
        return BinarySpatialFilter.original(this.expression1);
    }

    public Expression<? super R, ?> getOperand2() {
        return BinarySpatialFilter.original(this.expression2);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    @Override
    public boolean test(R r) {
        GeometryWrapper geometryWrapper;
        GeometryWrapper geometryWrapper2 = (GeometryWrapper)this.expression1.apply(r);
        if (geometryWrapper2 != null && (geometryWrapper = (GeometryWrapper)this.expression2.apply(r)) != null) {
            try {
                return geometryWrapper2.predicate(this.operatorType, geometryWrapper, this.context);
            }
            catch (RuntimeException runtimeException) {
                this.warning(runtimeException, true);
            }
        }
        return this.negativeResult();
    }

    @Override
    protected boolean negativeResult() {
        return SpatialOperationContext.negativeResult(this.operatorType);
    }
}

