/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.InstantList;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public class MovingFeatures {
    public static final DefaultAttributeType<Instant> TIME_AS_INSTANTS;
    private static final DefaultAttributeType<Number> TIME_AS_NUMBERS;
    private final Map<Vector, InstantList> cache;

    public static DefaultAttributeType<?> characteristic(boolean bl) {
        return bl ? TIME_AS_INSTANTS : TIME_AS_NUMBERS;
    }

    public MovingFeatures(MovingFeatures movingFeatures) {
        this.cache = movingFeatures != null ? movingFeatures.cache : new HashMap<Vector, InstantList>();
    }

    public final void setInstants(AbstractAttribute<?> abstractAttribute, long[] lArray) {
        AbstractAttribute<Instant> abstractAttribute2 = TIME_AS_INSTANTS.newInstance();
        abstractAttribute2.setValues(this.cache.computeIfAbsent(InstantList.vectorize(lArray), InstantList::new));
        abstractAttribute.characteristics().values().add(abstractAttribute2);
    }

    public static void setTimes(AbstractAttribute<?> abstractAttribute, Vector vector, DefaultTemporalCRS defaultTemporalCRS) {
        AbstractAttribute<Serializable> abstractAttribute2;
        if (defaultTemporalCRS != null) {
            Object[] objectArray = new Instant[vector.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = defaultTemporalCRS.toInstant(vector.doubleValue(i));
            }
            AbstractAttribute<Instant> abstractAttribute3 = TIME_AS_INSTANTS.newInstance();
            abstractAttribute3.setValues((Collection<Instant>)UnmodifiableArrayList.wrap((Object[])objectArray));
            abstractAttribute2 = abstractAttribute3;
        } else {
            AbstractAttribute<Number> abstractAttribute4 = TIME_AS_NUMBERS.newInstance();
            abstractAttribute4.setValues((Collection<Number>)vector);
            abstractAttribute2 = abstractAttribute4;
        }
        abstractAttribute.characteristics().values().add(abstractAttribute2);
    }

    static {
        LocalName localName = Names.createLocalName((CharSequence)"OGC", null, (CharSequence)"MF");
        Map<String, ScopedName> map = Collections.singletonMap("name", Names.createScopedName((GenericName)localName, null, (CharSequence)"datetimes"));
        TIME_AS_INSTANTS = new DefaultAttributeType<Object>(map, Instant.class, 0, Integer.MAX_VALUE, null, new DefaultAttributeType[0]);
        TIME_AS_NUMBERS = new DefaultAttributeType<Object>(map, Number.class, 0, Integer.MAX_VALUE, null, new DefaultAttributeType[0]);
    }
}

