/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.geoapi.filter;

import java.util.AbstractList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.geoapi.filter.Name;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

final class FilterExpressions<R>
extends AbstractList<Expression<? super R, ?>> {
    private final List<Filter<? super R>> filters;

    FilterExpressions(List<Filter<? super R>> list) {
        this.filters = Objects.requireNonNull(list);
    }

    @Override
    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public Expression<? super R, ?> get(int n) {
        return new Element<R>(this.filters.get(n));
    }

    private static final class Element<R>
    implements Expression<R, Boolean> {
        private final Filter<R> filter;

        Element(Filter<R> filter) {
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public ScopedName getFunctionName() {
            Enum<?> enum_ = this.filter.getOperatorType();
            String string = enum_.name().toLowerCase(Locale.US);
            if (string != null) {
                return Names.createScopedName((GenericName)Name.STANDARD, null, (CharSequence)string);
            }
            return Names.createScopedName((GenericName)Name.EXTENSION, null, (CharSequence)enum_.name());
        }

        @Override
        public List<Expression<? super R, ?>> getParameters() {
            return this.filter.getExpressions();
        }

        @Override
        public Boolean apply(R r) {
            return this.filter.test(r);
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> clazz) {
            if (clazz.isAssignableFrom(Boolean.class)) {
                return this;
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return ~this.filter.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Element && this.filter.equals(((Element)object).filter);
        }

        public String toString() {
            return "Expression[" + this.filter.toString() + ']';
        }
    }
}

