/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.rest;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryLinkService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/category/links"})
@Tag(name="/social/rest/category/links", description="Managing Category links")
public class CategoryLinkRest {
    @Autowired
    private CategoryLinkService categoryLinkService;

    @PostMapping(value={"{categoryId}"})
    @Secured(value={"users"})
    @Operation(summary="Creates a new association between an existing object and a Category", method="POST", description="This will create a new association between an existing object (Space, Activity, Note, Task ...) and a Category")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="409", description="Conflict")})
    public void link(HttpServletRequest request, @Parameter(description="Category id") @PathVariable(value="categoryId") long categoryId, @RequestBody CategoryObject object) {
        try {
            this.categoryLinkService.link(categoryId, object, request.getRemoteUser());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
    }

    @DeleteMapping(value={"{categoryId}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes an object from a category", method="DELETE", description="This will delete an object association from a category")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void unlink(HttpServletRequest request, @Parameter(description="Category id") @PathVariable(value="categoryId") long categoryId, @RequestBody CategoryObject object) {
        try {
            this.categoryLinkService.unlink(categoryId, object, request.getRemoteUser());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

