/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.rest.impl.richeditor;

import io.meeds.social.richeditor.RichEditorConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="richeditor/configuration")
@Tag(name="richeditor/configuration", description="Retrieves Rich Editor configurations")
public class RichEditorConfigurationRest
implements ResourceContainer {
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final Date DEFAULT_LAST_MODIFED = new Date();
    private static final long DEFAULT_LAST_MODIFED_HASH = DEFAULT_LAST_MODIFED.getTime();
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private RichEditorConfigurationService richEditorConfigurationService;
    private boolean useCache;

    public RichEditorConfigurationRest(RichEditorConfigurationService richEditorConfigurationService) {
        this.richEditorConfigurationService = richEditorConfigurationService;
        this.useCache = !PropertyManager.isDevelopping();
    }

    @GET
    @Operation(summary="Retrieves rich editor configuration Javascript file", method="GET", description="Returns list of tags")
    @Produces(value={"text/javascript"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getRichEditorConfiguration(@Context Request request, @Parameter(description="Rich Editor Type") @QueryParam(value="type") String type, @Parameter(description="The value of v parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        Response.ResponseBuilder builder;
        EntityTag eTag = new EntityTag(String.valueOf(DEFAULT_LAST_MODIFED_HASH));
        Response.ResponseBuilder responseBuilder = builder = this.useCache ? request.evaluatePreconditions(eTag) : null;
        if (builder == null) {
            String richEditorConfiguration = this.richEditorConfigurationService.getRichEditorConfiguration(type);
            builder = Response.ok((Object)richEditorConfiguration);
        }
        if (this.useCache) {
            builder.tag(eTag);
            builder.lastModified(DEFAULT_LAST_MODIFED);
            builder.cacheControl(CACHE_CONTROL);
            if (StringUtils.isNotBlank((CharSequence)version)) {
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
            }
        }
        return builder.build();
    }
}

