/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;

public class UserSetExternalInGateinPortal
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(UserSetExternalInGateinPortal.class);
    OrganizationService organizationService;

    public UserSetExternalInGateinPortal(OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.organizationService = organizationService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start upgrade process to add external info in gatein user profile");
        long startupTime = System.currentTimeMillis();
        try {
            Group group = this.organizationService.getGroupHandler().findGroupById("/platform/externals");
            ListAccess externalsMemberships = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
            int total = externalsMemberships.getSize();
            LOG.info((Object)("Number of users to update : " + total));
            int pageSize = 100;
            int current = 0;
            AtomicInteger updatedUserProfiles = new AtomicInteger(0);
            while (current < total) {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                Membership[] currentBatch = (Membership[])externalsMemberships.load(0, pageSize);
                Arrays.stream(currentBatch).forEach(membership -> {
                    long startTimeForUser = System.currentTimeMillis();
                    String username = membership.getUserName();
                    try {
                        UserProfile profile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
                        if (profile == null) {
                            profile = this.organizationService.getUserProfileHandler().createUserProfileInstance(username);
                        }
                        if (profile.getAttribute(UserProfile.OTHER_KEYS[2]) != null && String.valueOf(true).equals(profile.getAttribute(UserProfile.OTHER_KEYS[2]))) {
                            LOG.debug("External info already set in gatein profile for user {}", new Object[]{username});
                        } else {
                            profile.setAttribute(UserProfile.OTHER_KEYS[2], "true");
                            this.organizationService.getUserProfileHandler().saveUserProfile(profile, true);
                            updatedUserProfiles.getAndIncrement();
                            LOG.debug("External info added in gatein profile for user {}", new Object[]{username});
                            LOG.info("Progession : {} users updated on {} total users", new Object[]{updatedUserProfiles.get(), total});
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unable to get profile for user {}", new Object[]{username});
                    }
                });
                LOG.info("Progession : {} users updated on {} total users. It tooks {}ms", new Object[]{current += currentBatch.length, total, System.currentTimeMillis() - startupTime});
                RequestLifeCycle.end();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to find group externals");
        }
    }
}

