/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.rest;

import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.service.WalletContractService;
import io.meeds.wallet.utils.WalletUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/contract")
@RolesAllowed(value={"users"})
@Tag(name="/wallet/api/contract", description="Manages internally stored token contract detail")
public class WalletContractREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletContractREST.class);
    private WalletContractService contractService;

    public WalletContractREST(WalletContractService contractService) {
        this.contractService = contractService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves stored contract details in internal datasource", method="GET", description="Retrieves stored contract details in internal datasource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getContract(@Parameter(description="contract address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)"Empty contract address");
            return Response.status((int)400).build();
        }
        try {
            ContractDetail contractDetail = this.contractService.getContractDetail(address);
            if (contractDetail == null) {
                contractDetail = new ContractDetail();
            }
            return Response.ok((Object)contractDetail).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting contract details: " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="bin/{name}")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Retrieves contract binary", method="GET", description="returns contract bin content")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getBin(@Parameter(description="contract name", required=true) @PathParam(value="name") String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..") || name.contains("/") || name.contains("\\")) {
            LOG.error((Object)(WalletUtils.getCurrentUserId() + " has used a forbidden path character is used: '..' or '/' or '\\'"));
            return Response.status((int)401).build();
        }
        try {
            String contractBin = this.contractService.getContractFileContent(name, "bin");
            return Response.ok((Object)contractBin).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error retrieving contract BIN: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="abi/{name}")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Retrieves contract ABI", method="GET", description="returns contract ABI object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAbi(@Parameter(description="contract name", required=true) @PathParam(value="name") String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..") || name.contains("/") || name.contains("\\")) {
            LOG.error((Object)(WalletUtils.getCurrentUserId() + " has used a forbidden path character is used: '..' or '/' or '\\'"));
            return Response.status((int)401).build();
        }
        try {
            String contractAbi = this.contractService.getContractFileContent(name, "json");
            return Response.ok((Object)contractAbi).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error retrieving contract ABI: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }
}

