/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.distributions.tools;

import org.exoplatform.distributions.tools.JavaVersion;

public final class ExoTools {
    public static final String systemJavaVersion = System.getProperty("java.version");
    public static final String CMD_JAVA_8 = "isJava8";
    public static final String CMD_JAVA_8_OR_MORE = "isJava8OrSuperior";
    public static final String CMD_JAVA_9 = "isJava9";
    public static final String CMD_JAVA_9_OR_MORE = "isJava9OrSuperior";

    public static void main(String[] args) {
        int result = ExoTools.doMain(args);
        System.exit(result);
    }

    private static int doMain(String[] args) {
        if (null == systemJavaVersion || systemJavaVersion.equals("") || args.length == 0) {
            return -1;
        }
        JavaVersion javaVersion = new JavaVersion(systemJavaVersion);
        switch (args[0]) {
            case "isJava8": {
                return javaVersion.isMinorVersionEqual(8);
            }
            case "isJava8OrSuperior": {
                return javaVersion.isMinorVersionSuperiorOrEqual(8);
            }
            case "isJava9": {
                return javaVersion.isMajorVersionEqual(9);
            }
            case "isJava9OrSuperior": {
                return javaVersion.isMajorVersionSuperiorOrEqual(9);
            }
        }
        return -1;
    }
}

