/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.PortletTemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;

public class ApplicationTemplatesHandler
extends ComponentHandler {
    private static final String PORTLET_TEMPLATE_PATH = "portlet.template.path";
    private static final String PORTLET_NAME = "portletName";
    private static final String TEMPLATES_LOCATION = "application-templates/";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public ApplicationTemplatesHandler() {
        super.setTargetComponentName(ApplicationTemplateManagerService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Session dmsWorkspaceSession = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, PortletTemplatePlugin.class);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            DMSConfiguration dmsConfiguration = (DMSConfiguration)container.getComponentInstanceOfType(DMSConfiguration.class);
            String dmsSystemWorkspace = dmsConfiguration.getConfig(defaumtRepositoryName).getSystemWorkspace();
            NodeHierarchyCreator hierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            String cmsViewTemplatesPath = hierarchyCreator.getJcrPath("viewTemplatesPath");
            dmsWorkspaceSession = repository.getSystemSession(dmsSystemWorkspace);
            Node basedTemplateHome = (Node)dmsWorkspaceSession.getItem(cmsViewTemplatesPath);
            ApplicationTemplateManagerService applicationTemplateService = (ApplicationTemplateManagerService)container.getComponentInstanceOfType(ApplicationTemplateManagerService.class);
            List applicationNames = applicationTemplateService.getAllManagedPortletName(defaumtRepositoryName);
            for (String applicationName : applicationNames) {
                Node portletTemplateHome = basedTemplateHome.getNode(applicationName);
                ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
                templatesComponentPlugin.setName("templates.plugin");
                templatesComponentPlugin.setSetMethod("addPlugin");
                templatesComponentPlugin.setType(PortletTemplatePlugin.class.getName());
                InitParams templatesPluginInitParams = new InitParams();
                templatesComponentPlugin.setInitParams(templatesPluginInitParams);
                componentPluginsList.add(templatesComponentPlugin);
                ValueParam valueParam = new ValueParam();
                valueParam.setName(PORTLET_NAME);
                valueParam.setValue(portletTemplateHome.getName());
                templatesPluginInitParams.addParam((Object)valueParam);
                valueParam = new ValueParam();
                valueParam.setName(PORTLET_TEMPLATE_PATH);
                valueParam.setValue(TEMPLATES_LOCATION + portletTemplateHome.getName());
                templatesPluginInitParams.addParam((Object)valueParam);
                NodeIterator categoriesNodeIterator = portletTemplateHome.getNodes();
                while (categoriesNodeIterator.hasNext()) {
                    Node categoryNode = categoriesNodeIterator.nextNode();
                    NodeIterator templateNodeIterator = categoryNode.getNodes();
                    while (templateNodeIterator.hasNext()) {
                        Node templateNode = templateNodeIterator.nextNode();
                        PortletTemplatePlugin.PortletTemplateConfig portletTemplateConfig = new PortletTemplatePlugin.PortletTemplateConfig();
                        portletTemplateConfig.setCategory(categoryNode.getName());
                        portletTemplateConfig.setTemplateName(templateNode.getName());
                        String templateData = templateNode.getProperty("exo:templateFile").getString();
                        zos.putNextEntry(new ZipEntry(TEMPLATES_LOCATION + applicationName + "/" + categoryNode.getName() + "/" + templateNode.getName()));
                        zos.write(templateData.getBytes());
                        zos.closeEntry();
                        ObjectParameter objectParam = new ObjectParameter();
                        String templateName = templateNode.getName().replace(".gtmpl", "");
                        objectParam.setName(templateName + ".application.template.configuration");
                        objectParam.setObject((Object)portletTemplateConfig);
                        templatesPluginInitParams.addParam((Object)objectParam);
                    }
                }
            }
            dmsWorkspaceSession.logout();
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }
}

