/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.backup.exporter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.NodeDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.PropertyDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.xml.exporting.WorkspaceSystemViewStreamExporter;

public class CollaborationWorkspaceStreamExporter
extends WorkspaceSystemViewStreamExporter {
    private boolean deleteWCMServicesLogNodes;
    private static List<String> wcmServicesLogNodesNames = null;
    private static final String FAQ_SERVICE_NODE_NAME = "faqApp";
    private static final String FORUM_SERVICE_NODE_NAME = "ForumService";

    public CollaborationWorkspaceStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse, boolean deleteWCMServicesLogNodes) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        this.deleteWCMServicesLogNodes = deleteWCMServicesLogNodes;
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            String nodeName = this.getExportName((ItemData)node, false);
            if (this.deleteWCMServicesLogNodes && this.currentLevel == 2 && wcmServicesLogNodesNames.contains(nodeName)) {
                return;
            }
            if (this.currentLevel == 2 && (nodeName.equals(FORUM_SERVICE_NODE_NAME) || nodeName.equals(FAQ_SERVICE_NODE_NAME))) {
                return;
            }
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                List properties = this.dataManager.getChildPropertiesData(node);
                Collections.sort(properties, new PropertyDataOrderComparator());
                TransientPropertyData propertyToModifyData = null;
                for (int index = 0; index < properties.size() && propertyToModifyData == null; ++index) {
                    PropertyData propertyData = (PropertyData)properties.get(index);
                    if (this.getExportName((ItemData)propertyData, false).equals("exo:emailAddress")) {
                        propertyToModifyData = new TransientPropertyData(propertyData.getQPath(), propertyData.getIdentifier(), propertyData.getPersistedVersion(), propertyData.getType(), propertyData.getParentIdentifier(), true);
                        propertyToModifyData.setValues(propertyData.getValues());
                        properties.remove(index);
                        properties.add(index, propertyToModifyData);
                    }
                    if (!this.getExportName((ItemData)propertyData, false).equals("exo:lifecyclePhase")) continue;
                    propertyToModifyData = new TransientPropertyData(propertyData.getQPath(), propertyData.getIdentifier(), propertyData.getPersistedVersion(), propertyData.getType(), propertyData.getParentIdentifier(), true);
                    propertyToModifyData.setValues(propertyData.getValues());
                    properties.remove(index);
                    properties.add(index, propertyToModifyData);
                    List list = propertyToModifyData.getValues();
                    assert (list.size() == 1);
                    ValueData valueData = (ValueData)list.get(0);
                    String value = new String(valueData.getAsByteArray());
                    TransientValueData newValueData = null;
                    if (value.equals("add")) {
                        newValueData = new TransientValueData("node_added");
                        list.clear();
                        list.add(newValueData);
                        continue;
                    }
                    if (!value.equals("remove")) continue;
                    newValueData = new TransientValueData("node_remove");
                    list.clear();
                    list.add(newValueData);
                }
                for (PropertyData data : properties) {
                    InternalQName propName = data.getQPath().getName();
                    if (Constants.JCR_LOCKISDEEP.equals((Object)propName) || Constants.JCR_LOCKOWNER.equals((Object)propName)) continue;
                    data.accept((ItemDataVisitor)this);
                }
                if (!this.isNoRecurse() && this.currentLevel > 0) {
                    List nodes = this.dataManager.getChildNodesData(node);
                    Collections.sort(nodes, new NodeDataOrderComparator());
                    for (NodeData data : nodes) {
                        data.accept((ItemDataVisitor)this);
                    }
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (Exception re) {
            this.currentLevel = 0;
            throw new RuntimeException(re);
        }
    }

    static {
        wcmServicesLogNodesNames = Arrays.asList("WCMContentInitializerService", "ContentInitializerService", "NewsletterInitializationService");
    }
}

