/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTemplateHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository";
    private static final String GTMPL_EXTENSION = ".gtmpl";
    private static final String TEMPLATES_NODETYPE_LOCATION = "metadata-templates";
    private static final String CSS_EXTENSION = ".css";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public MetadataTemplateHandler() {
        super.setTargetComponentName(MetadataService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Session dmsWorkspaceSession = null;
        try {
            ValueParam valueParam;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, TemplatePlugin.class);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("addPlugins");
            templatesComponentPlugin.setSetMethod("addPlugins");
            templatesComponentPlugin.setType(TemplatePlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            if (component.getInitParams() != null) {
                valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                String autoCreateInNewRepository = "false";
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = originalParam.getValue();
                }
                valueParam.setValue(autoCreateInNewRepository);
                templatesPluginInitParams.addParam((Object)valueParam);
            }
            valueParam = new ValueParam();
            valueParam.setName("storedLocation");
            valueParam.setValue(TEMPLATES_NODETYPE_LOCATION);
            templatesPluginInitParams.addParam((Object)valueParam);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            valueParam = new ValueParam();
            valueParam.setName("repository");
            valueParam.setValue(defaumtRepositoryName);
            templatesPluginInitParams.addParam((Object)valueParam);
            componentPluginsList.add(templatesComponentPlugin);
            TemplateConfig templateConfig = new TemplateConfig();
            ArrayList<TemplateConfig.NodeType> metadatsList = new ArrayList<TemplateConfig.NodeType>();
            templateConfig.setNodeTypes(metadatsList);
            DMSConfiguration dmsConfiguration = (DMSConfiguration)container.getComponentInstanceOfType(DMSConfiguration.class);
            String dmsSystemWorkspace = dmsConfiguration.getConfig(defaumtRepositoryName).getSystemWorkspace();
            NodeHierarchyCreator hierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            String metadataTemplatesPath = hierarchyCreator.getJcrPath("metadataPath");
            dmsWorkspaceSession = repository.getSystemSession(dmsSystemWorkspace);
            Node baseTemplateHome = (Node)dmsWorkspaceSession.getItem(metadataTemplatesPath);
            NodeIterator matadataNodesIterator = baseTemplateHome.getNodes();
            while (matadataNodesIterator.hasNext()) {
                Node matadataNode = matadataNodesIterator.nextNode();
                TemplateConfig.NodeType nodeTypeTemplates = new TemplateConfig.NodeType();
                metadatsList.add(nodeTypeTemplates);
                if (matadataNode.hasProperty(TemplatePlugin.TEMPLATE_LABEL)) {
                    nodeTypeTemplates.setLabel(matadataNode.getProperty(TemplatePlugin.TEMPLATE_LABEL).getString());
                }
                nodeTypeTemplates.setNodetypeName(matadataNode.getName());
                if (matadataNode.hasProperty(TemplatePlugin.DOCUMENT_TEMPLATE_PROP)) {
                    nodeTypeTemplates.setDocumentTemplate(matadataNode.getProperty(TemplatePlugin.DOCUMENT_TEMPLATE_PROP).getBoolean());
                }
                if (matadataNode.hasNode(TemplatePlugin.DIALOGS)) {
                    NodeIterator dialogsNodeIterator = matadataNode.getNode(TemplatePlugin.DIALOGS).getNodes();
                    List<TemplateConfig.Template> dialogs = this.generateDialogTemplates(zos, matadataNode.getName(), dialogsNodeIterator);
                    nodeTypeTemplates.setReferencedDialog(dialogs);
                }
                if (matadataNode.hasNode(TemplatePlugin.VIEWS)) {
                    NodeIterator viewsNodeIterator = matadataNode.getNode(TemplatePlugin.VIEWS).getNodes();
                    List<TemplateConfig.Template> views = this.generateViewTemplate(zos, matadataNode.getName(), viewsNodeIterator);
                    nodeTypeTemplates.setReferencedView(views);
                }
                if (!matadataNode.hasNode(TemplatePlugin.SKINS)) continue;
                NodeIterator skinsNodeIterator = matadataNode.getNode(TemplatePlugin.SKINS).getNodes();
                List<TemplateConfig.Template> skins = this.generateSkinTemplate(zos, matadataNode.getName(), skinsNodeIterator);
                nodeTypeTemplates.setReferencedSkin(skins);
            }
            ObjectParameter objectParam = new ObjectParameter();
            objectParam.setName("template.configuration");
            objectParam.setObject((Object)templateConfig);
            templatesPluginInitParams.addParam((Object)objectParam);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    private List<TemplateConfig.Template> generateSkinTemplate(ZipOutputStream zos, String nodeType, NodeIterator skinsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> skins = new ArrayList<TemplateConfig.Template>();
        while (skinsNodeIterator.hasNext()) {
            Node templateNode = skinsNodeIterator.nextNode();
            TemplateConfig.Template skinTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType + "/" + TemplatePlugin.SKINS + "/" + templateNode.getName();
            skinTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplatePlugin.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            skinTemplate.setRoles(roles);
            skins.add(skinTemplate);
            String template = templateNode.getProperty(TemplatePlugin.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + CSS_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return skins;
    }

    private List<TemplateConfig.Template> generateViewTemplate(ZipOutputStream zos, String nodeType, NodeIterator viewsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> views = new ArrayList<TemplateConfig.Template>();
        while (viewsNodeIterator.hasNext()) {
            Node templateNode = viewsNodeIterator.nextNode();
            TemplateConfig.Template viewTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType + "/" + TemplatePlugin.VIEWS + "/" + templateNode.getName();
            viewTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplatePlugin.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            viewTemplate.setRoles(roles);
            views.add(viewTemplate);
            String template = templateNode.getProperty(TemplatePlugin.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + GTMPL_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return views;
    }

    private List<TemplateConfig.Template> generateDialogTemplates(ZipOutputStream zos, String nodeType, NodeIterator dialogsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> dialogs = new ArrayList<TemplateConfig.Template>();
        while (dialogsNodeIterator.hasNext()) {
            Node templateNode = dialogsNodeIterator.nextNode();
            TemplateConfig.Template dialogTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType + "/" + TemplatePlugin.DIALOGS + "/" + templateNode.getName();
            dialogTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplatePlugin.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            dialogTemplate.setRoles(roles);
            dialogs.add(dialogTemplate);
            String template = templateNode.getProperty(TemplatePlugin.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + GTMPL_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return dialogs;
    }
}

