/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.rest;

import java.io.File;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.migration.aio.backup.AIOBackupMigrationService;
import org.exoplatform.platform.migration.common.component.ContainerParamExtractor;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

@URITemplate(value="/migration/backup/")
public class AIOBackupMigrationREST
implements ResourceContainer {
    private Log log = ExoLogger.getLogger(this.getClass());
    private AIOBackupMigrationService backupService;
    private ContainerParamExtractor containerParamExtractor_ = null;

    public AIOBackupMigrationREST(AIOBackupMigrationService backupService, ContainerParamExtractor containerParamExtractor) {
        this.backupService = backupService;
        this.containerParamExtractor_ = containerParamExtractor;
    }

    @HTTPMethod(value="GET")
    @URITemplate
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response generateBackupForm() throws Exception {
        StringBuffer htmlContainersLink = new StringBuffer();
        htmlContainersLink.append("<html xmlns='http://www.w3.org/1999/xhtml'><body xmlns='http://www.w3.org/1999/xhtml'>");
        htmlContainersLink.append("<fieldset>");
        htmlContainersLink.append("<legend>Generates Collaboration&System Workspace backup files</legend>");
        htmlContainersLink.append("<form action='/" + this.containerParamExtractor_.getContainerId((ExoContainer)PortalContainer.getInstance()) + "/" + this.containerParamExtractor_.getContainerRestContext((ExoContainer)PortalContainer.getInstance()) + "/migration/backup/start' method='get'>");
        htmlContainersLink.append("Backup Location : <input type='text' name='location'/><BR/>");
        htmlContainersLink.append("<input type='submit'/>");
        htmlContainersLink.append("</form>");
        htmlContainersLink.append("</fieldset>");
        return Response.Builder.ok().entity((Object)htmlContainersLink.toString(), "text/html").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/start/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response startBackup(@QueryParam(value="location") String backupLocation) throws Exception {
        try {
            BackupConfig config = new BackupConfig();
            config.setBuckupType(0);
            config.setRepository("repository");
            config.setWorkspace("collaboration");
            config.setBackupDir(new File(backupLocation));
            this.backupService.startBackupWorkspace(config);
            config = new BackupConfig();
            config.setBuckupType(0);
            config.setRepository("repository");
            config.setWorkspace("system");
            config.setBackupDir(new File(backupLocation));
            this.backupService.startBackupWorkspace(config);
            config = new BackupConfig();
            config.setBuckupType(0);
            config.setRepository("repository");
            config.setWorkspace("knowledge");
            config.setBackupDir(new File(backupLocation));
            this.backupService.startBackupWorkspace(config);
        }
        catch (Exception e) {
            this.log.error((Object)"Can't start backup", (Throwable)e);
        }
        return Response.Builder.ok().entity((Object)"The Convertor Job has been executed, please wait until it ends!", "text/html").build();
    }
}

