/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Gadgets;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;

public class UserPortalConfigHandler
extends ComponentHandler {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public UserPortalConfigHandler(InitParams initParams) {
        super.setTargetComponentName(UserPortalConfigService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            this.writePortalConfigs(zos, container);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            return entry;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            return null;
        }
    }

    private void writePortalConfigs(ZipOutputStream zos, ExoContainer container) throws Exception {
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        Query pageNavigationQuery = new Query(null, null, PageNavigation.class);
        List findedPageNavigations = dataStorage.find(pageNavigationQuery).getAll();
        for (PageNavigation pageNavigation : findedPageNavigations) {
            Gadgets gadgets;
            byte[] bytes;
            String ownerType = pageNavigation.getOwnerType();
            String ownerId = pageNavigation.getOwnerId();
            String portalConfigForlder = ownerType + "/" + ownerId + "/";
            if ("portal".equals(ownerType)) {
                zos.putNextEntry(new ZipEntry(portalConfigForlder + "portal.xml"));
                PortalConfig portalConfig = dataStorage.getPortalConfig(ownerId);
                bytes = this.toXML(portalConfig);
                zos.write(bytes);
                zos.closeEntry();
            }
            zos.putNextEntry(new ZipEntry(portalConfigForlder + "pages.xml"));
            Query portalConfigQuery = new Query(ownerType, ownerId, Page.class);
            List findedPages = dataStorage.find(portalConfigQuery).getAll();
            Page.PageSet pageSet = new Page.PageSet();
            pageSet.setPages((ArrayList)findedPages);
            byte[] bytes2 = this.toXML(pageSet);
            zos.write(bytes2);
            zos.closeEntry();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding portalConfig: Pages entry: " + portalConfigForlder + "pages.xml"));
            }
            zos.putNextEntry(new ZipEntry(portalConfigForlder + "navigation.xml"));
            byte[] bytes3 = this.toXML(pageNavigation);
            zos.write(bytes3);
            zos.closeEntry();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding portalConfig: Navigation entry: " + portalConfigForlder + "navigation.xml"));
            }
            zos.putNextEntry(new ZipEntry(portalConfigForlder + "portlet-preferences.xml"));
            Query portletPreferencesQuery = new Query(ownerType, ownerId, PortletPreferences.class);
            List findedPortletPreferences = dataStorage.find(portletPreferencesQuery).getAll();
            PortletPreferences.PortletPreferencesSet portletPreferencesSet = new PortletPreferences.PortletPreferencesSet();
            portletPreferencesSet.setPortlets((ArrayList)findedPortletPreferences);
            bytes2 = this.toXML(portletPreferencesSet);
            zos.write(bytes2);
            zos.closeEntry();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding portalConfig: PortletPreferences entry: " + portalConfigForlder + "portlet-preferences.xml"));
            }
            if ((gadgets = dataStorage.getGadgets(ownerType + "::" + ownerId)) == null || gadgets.getChildren() == null || gadgets.getChildren().size() <= 0) continue;
            zos.putNextEntry(new ZipEntry(portalConfigForlder + "gadgets.xml"));
            bytes = this.toXML(gadgets);
            zos.write(bytes);
            zos.closeEntry();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Adding portalConfig: Gadgets entry: " + portalConfigForlder + "gadgets.xml"));
        }
    }
}

