/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.bos.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.platform.migration.bos.exporter.SystemWorkspaceStreamExporter;
import org.exoplatform.platform.migration.bos.exporter.WorkspaceStreamExporter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.xml.sax.SAXException;

@Managed
@ManagedDescription(value="BOS Backup Service")
@NameTemplate(value={@Property(key="name", value="BOSBackupService"), @Property(key="service", value="bonita-ext"), @Property(key="type", value="platform")})
public class BOSBackupService
implements Startable {
    private RepositoryService repositoryService;
    private RepositoryEntry defaultRepositoryEntry;
    private String defaultRepositoryName;
    private final Log logger = ExoLogger.getLogger((String)this.getClass().getName());

    public BOSBackupService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Exports the repository data to a backup location")
    public void doBackup(@ManagedName(value="backupLocation") String backupLocation) {
        this.logger.info((Object)("Starting the backup operation.. Repository: " + this.defaultRepositoryName));
        try {
            ManageableRepository repository = this.repositoryService.getDefaultRepository();
            ArrayList workspaceEntries = this.defaultRepositoryEntry.getWorkspaceEntries();
            String systemWorkspaceName = this.defaultRepositoryEntry.getSystemWorkspaceName();
            for (WorkspaceEntry workspace : workspaceEntries) {
                String workspaceName = workspace.getName();
                SessionImpl session = (SessionImpl)repository.getSystemSession(workspaceName);
                BackupConfig config = new BackupConfig();
                config.setBackupType(0);
                config.setRepository(this.defaultRepositoryEntry.getName());
                config.setWorkspace(workspaceName);
                if (backupLocation == null) {
                    this.logger.warn((Object)"Bachup operation aborted...");
                    throw new IOException("The backupLocation field should not be empty!");
                }
                config.setBackupDir(new File(backupLocation + File.separator + workspaceName));
                Calendar timeStamp = Calendar.getInstance();
                URL url = this.createStorage(config, timeStamp);
                FileOutputStream fos = new FileOutputStream(url.getFile());
                try {
                    WorkspaceStreamExporter exporter;
                    WorkspaceContainerFacade workspaceContainer = repository.getWorkspaceContainer(workspaceName);
                    LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponent(LocalWorkspaceDataManagerStub.class);
                    SessionDataManager dataManager = new SessionDataManager(session, workspaceDataManager);
                    LocationFactory factory = new LocationFactory((NamespaceAccessor)((NamespaceRegistryImpl)repository.getNamespaceRegistry()));
                    WorkspaceEntry wsConfig = (WorkspaceEntry)workspaceContainer.getComponent(WorkspaceEntry.class);
                    FileCleanerHolder cleanerHolder = (FileCleanerHolder)workspaceContainer.getComponent(FileCleanerHolder.class);
                    ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, cleanerHolder);
                    XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                    XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(fos, "UTF-8");
                    ItemData srcItemData = dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
                    if (srcItemData == null) {
                        throw new PathNotFoundException("Root node not found");
                    }
                    if (!workspace.getName().equals(systemWorkspaceName)) {
                        exporter = new WorkspaceStreamExporter(streamWriter, (ItemDataConsumer)dataManager, repository.getNamespaceRegistry(), valueFactoryImpl, false, false);
                        exporter.export((NodeData)srcItemData);
                    } else {
                        exporter = new SystemWorkspaceStreamExporter(streamWriter, (ItemDataConsumer)dataManager, repository.getNamespaceRegistry(), valueFactoryImpl, false, false);
                        exporter.export((NodeData)srcItemData);
                    }
                }
                catch (XMLStreamException e) {
                    this.logger.error((Object)("Full backup failed... " + e));
                }
                catch (SAXException e) {
                    this.logger.error((Object)("Full backup failed... " + e));
                }
                finally {
                    session.logout();
                }
                this.logger.info((Object)("Full backup succeeded: " + url.getPath()));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Full backup failed... " + e));
        }
        catch (RepositoryException e) {
            this.logger.error((Object)("Full backup failed... " + (Object)((Object)e)));
        }
        catch (RepositoryConfigurationException e) {
            this.logger.error((Object)("Full backup failed... " + (Object)((Object)e)));
        }
    }

    private URL createStorage(BackupConfig config, Calendar timeStamp) throws IOException {
        FileNameProducer fileNameProducer = new FileNameProducer(config.getRepository(), config.getWorkspace(), config.getBackupDir().getAbsolutePath(), timeStamp, true);
        return new URL("file:" + fileNameProducer.getNextFile().getAbsolutePath());
    }

    public void start() {
        this.logger.info((Object)"BOS Backup Service started");
        this.defaultRepositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
        try {
            this.defaultRepositoryEntry = this.repositoryService.getConfig().getRepositoryConfiguration(this.defaultRepositoryName);
        }
        catch (RepositoryConfigurationException e) {
            this.logger.error((Object)("Cannot proceed BOS Backup Service initialization... " + (Object)((Object)e)));
        }
    }

    public void stop() {
        this.logger.info((Object)"BOS Backup Service stopped");
    }
}

