/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.common.component;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.migration.common.component.ContainerParamExtractor;
import org.exoplatform.platform.migration.common.component.Logger;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class MarshallConfigurationService {
    Map<String, ComponentHandler> handlersMap = new HashMap<String, ComponentHandler>();
    private ContainerParamExtractor containerParamExtractor_ = null;
    private Logger logger_ = null;
    private Comparator<ComponentPlugin> componentPluginComparator = new Comparator<ComponentPlugin>(){

        @Override
        public int compare(ComponentPlugin o1, ComponentPlugin o2) {
            int compare = 0;
            if (o1.getName() != null && o2.getName() != null) {
                compare = o1.getName().compareTo(o2.getName());
            }
            if (compare == 0) {
                if (o1.getType() != null && o2.getType() != null) {
                    compare = o1.getType().compareTo(o2.getType());
                }
                if (compare == 0) {
                    if (o1.getDescription() != null && o2.getDescription() != null) {
                        compare = o1.getDescription().compareTo(o2.getDescription());
                    }
                    if (compare == 0) {
                        try {
                            if (o1.getInitParams() != null || o2.getInitParams() != null) {
                                compare = o1.getInitParams() == o2.getInitParams() ? 0 : (o1.getInitParams() == null ? -1 : (o2.getInitParams() == null ? 1 : MarshallConfigurationService.this.getInitParamsSize(o1.getInitParams()) - MarshallConfigurationService.this.getInitParamsSize(o2.getInitParams())));
                            }
                        }
                        catch (Exception exception) {
                            MarshallConfigurationService.this.logger_.error("Error while comparing initParams: will return 0  ...", exception);
                            return 0;
                        }
                    }
                }
            }
            return compare;
        }
    };

    public MarshallConfigurationService(ContainerParamExtractor containerParamExtractor) {
        this.containerParamExtractor_ = containerParamExtractor;
    }

    public void addHandler(ComponentHandler componentHandler) {
        this.handlersMap.put(componentHandler.getTargetComponentName(), componentHandler);
    }

    public String generateHTMLContainersList() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.logger_ = (Logger)container.getComponentInstanceOfType(Logger.class);
        this.logger_.setLogger(this.getClass());
        String containerId = this.containerParamExtractor_.getContainerId(container);
        String containerRestContextName = this.containerParamExtractor_.getContainerRestContext(container);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Current container: " + containerId);
            this.logger_.debug("Current rest context: " + containerRestContextName);
            this.logger_.debug("Generating containers list ...");
        }
        StringBuffer urlSuffixBuffer = new StringBuffer("<a href='/" + containerId + "/" + containerRestContextName);
        urlSuffixBuffer.append("/containersConfiguration");
        urlSuffixBuffer.append("/ComponentsList/");
        urlSuffixBuffer.append("?");
        urlSuffixBuffer.append("containerId");
        urlSuffixBuffer.append("=");
        String componentsListURLSuffix = urlSuffixBuffer.toString();
        urlSuffixBuffer.delete(0, urlSuffixBuffer.length());
        urlSuffixBuffer.append("<a href='/" + containerId + "/" + containerRestContextName);
        urlSuffixBuffer.append("/containersConfiguration");
        urlSuffixBuffer.append("/exportContainerComponents/");
        urlSuffixBuffer.append("?");
        urlSuffixBuffer.append("containerId");
        urlSuffixBuffer.append("=");
        String exportComponentsURLSuffix = urlSuffixBuffer.toString();
        StringBuffer responseStringBuffer = new StringBuffer();
        ExoContainer topContainer = ExoContainerContext.getTopContainer();
        responseStringBuffer.append("<html xmlns='http://www.w3.org/1999/xhtml'><body xmlns='http://www.w3.org/1999/xhtml'>");
        responseStringBuffer.append("<fieldset>");
        responseStringBuffer.append("<legend>RootContainer</legend>");
        responseStringBuffer.append(componentsListURLSuffix);
        responseStringBuffer.append(topContainer.getContext().getName());
        responseStringBuffer.append("'>");
        responseStringBuffer.append("Components List");
        responseStringBuffer.append("</a>\r\n<br/>");
        responseStringBuffer.append(exportComponentsURLSuffix);
        responseStringBuffer.append(topContainer.getContext().getName());
        responseStringBuffer.append("'>");
        responseStringBuffer.append("Export all Components");
        responseStringBuffer.append("</a>\r\n<br/>");
        responseStringBuffer.append("</fieldset><br/>");
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Container: " + topContainer.getContext().getName());
        }
        List portalContainers = topContainer.getComponentInstancesOfType(PortalContainer.class);
        for (PortalContainer portalContainer : portalContainers) {
            responseStringBuffer.append("<fieldset>");
            responseStringBuffer.append("<legend>");
            responseStringBuffer.append("PortalContainer : ");
            responseStringBuffer.append(portalContainer.getContext().getName());
            responseStringBuffer.append("</legend>");
            responseStringBuffer.append(componentsListURLSuffix);
            responseStringBuffer.append(portalContainer.getContext().getName());
            responseStringBuffer.append("'>");
            responseStringBuffer.append("Components List");
            responseStringBuffer.append("</a>\r\n<br/>");
            responseStringBuffer.append(exportComponentsURLSuffix);
            responseStringBuffer.append(portalContainer.getContext().getName());
            responseStringBuffer.append("'>");
            responseStringBuffer.append("Export all Components");
            responseStringBuffer.append("</a>\r\n<br/>");
            responseStringBuffer.append("</fieldset><br/>");
            if (!this.logger_.isDebugEnabled()) continue;
            this.logger_.debug("Container: " + portalContainer.getContext().getName());
        }
        responseStringBuffer.append("</body></html>");
        return responseStringBuffer.toString();
    }

    public String generateHTMLComponentsList(String containerId) throws Exception {
        ExoContainer container = null;
        container = containerId == null || containerId.equalsIgnoreCase("root") ? ExoContainerContext.getTopContainer() : ExoContainerContext.getContainerByName((String)containerId);
        String containerName = this.containerParamExtractor_.getContainerId(container);
        String containerRestContextName = this.containerParamExtractor_.getContainerRestContext(container);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Selected container: " + containerId);
            this.logger_.debug("Generating components list ...");
        }
        StringBuffer responseStringBuffer = new StringBuffer();
        Collection components = ((ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class)).getComponents();
        responseStringBuffer.append("<html xmlns='http://www.w3.org/1999/xhtml'><body xmlns='http://www.w3.org/1999/xhtml'>");
        StringBuffer urlSuffixBuffer = new StringBuffer("<a href='/" + containerName + "/" + containerRestContextName);
        urlSuffixBuffer.append("/containersConfiguration");
        urlSuffixBuffer.append("/getComponentConfiguration/");
        urlSuffixBuffer.append("?");
        urlSuffixBuffer.append("containerId");
        urlSuffixBuffer.append("=");
        urlSuffixBuffer.append(containerName);
        urlSuffixBuffer.append("&");
        urlSuffixBuffer.append("componentKey");
        urlSuffixBuffer.append("=");
        String urlSuffix = urlSuffixBuffer.toString();
        for (Object component : components) {
            responseStringBuffer.append(urlSuffix);
            responseStringBuffer.append(((Component)component).getKey());
            responseStringBuffer.append("'>");
            responseStringBuffer.append(((Component)component).getKey());
            responseStringBuffer.append("</a>\r\n<br/>");
        }
        responseStringBuffer.append("</body></html>");
        return responseStringBuffer.toString();
    }

    public ComponentHandler.Entry getComponentConfiguration(String containerId, String componentKey) throws Exception {
        ExoContainer container = ExoContainerContext.getContainerByName((String)containerId);
        ConfigurationManager configurationManager = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        Component component = configurationManager.getConfiguration().getComponent(componentKey);
        ExternalComponentPlugins externalComponentPlugins = configurationManager.getConfiguration().getExternalComponentPlugins(component.getKey());
        if (externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
            if (component.getComponentPlugins() == null) {
                component.setComponentPlugins((ArrayList)externalComponentPlugins.getComponentPlugins());
            } else {
                component.getComponentPlugins().addAll(externalComponentPlugins.getComponentPlugins());
            }
            if (component.getComponentPlugins() == null) {
                Collections.sort(component.getComponentPlugins(), this.componentPluginComparator);
            }
        }
        ComponentHandler handler = this.handlersMap.get(component.getKey());
        ComponentHandler.Entry configurationEntry = null;
        if (handler != null) {
            configurationEntry = handler.invoke(component, container);
        } else {
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            configurationEntry = new ComponentHandler.Entry(component.getKey());
            configurationEntry.setContent(this.toXML(configuration));
            configurationEntry.setType(ComponentHandler.EntryType.XML);
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Generating component configuration ...");
            this.logger_.debug("Selected container: " + containerId);
            this.logger_.debug("Selected component: " + componentKey);
        }
        return configurationEntry;
    }

    public ComponentHandler.Entry getAllComponentsConfiguration(String containerId) throws Exception {
        ComponentHandler.Entry entry;
        ExoContainer container = ExoContainerContext.getContainerByName((String)containerId);
        ConfigurationManager configurationManager = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        Collection components = configurationManager.getConfiguration().getComponents();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        for (Component component : components) {
            entry = this.getComponentConfiguration(containerId, component.getKey());
            zos.putNextEntry(new ZipEntry(component.getKey() + (Object)((Object)entry.getType())));
            zos.write(entry.getContent());
            zos.closeEntry();
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Generating all components configuration ...");
            this.logger_.debug("Selected container: " + containerId);
        }
        Collection componentLifecyclePlugins = configurationManager.getConfiguration().getComponentLifecyclePlugins();
        Collection containerLifecyclePlugins = configurationManager.getConfiguration().getContainerLifecyclePlugins();
        if (containerLifecyclePlugins != null && componentLifecyclePlugins != null && componentLifecyclePlugins.size() > 0 && containerLifecyclePlugins.size() > 0) {
            Configuration configuration = new Configuration();
            for (Object componentLifecyclePlugin : componentLifecyclePlugins) {
                configuration.addComponentLifecyclePlugin(componentLifecyclePlugin);
            }
            for (Object containerLifecyclePlugin : containerLifecyclePlugins) {
                configuration.addContainerLifecyclePlugin(containerLifecyclePlugin);
            }
            zos.putNextEntry(new ZipEntry("LifecyclePlugins.xml"));
            byte[] bytes = this.toXML(configuration);
            zos.write(bytes);
            zos.closeEntry();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Generating all component lifecycle plugins ...");
                this.logger_.debug("Selected container: " + containerId);
            }
        }
        zos.close();
        entry = new ComponentHandler.Entry("ExoContainer_Configuration_" + containerId);
        entry.setType(ComponentHandler.EntryType.ZIP);
        entry.setContent(out.toByteArray());
        return entry;
    }

    public int getInitParamsSize(InitParams initParams) throws JiBXException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument((Object)initParams, "UTF-8", Boolean.valueOf(false), (OutputStream)out);
        return out.size();
    }

    public byte[] toXML(Object obj) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception ie) {
            this.logger_.error("Error while converting to XML object ...", ie);
            return null;
        }
    }
}

