/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.backup;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.migration.aio.backup.exporter.CollaborationWorkspaceStreamExporter;
import org.exoplatform.platform.migration.aio.backup.exporter.KnowledgeWorkspaceStreamExporter;
import org.exoplatform.platform.migration.aio.backup.exporter.SystemWorkspaceStreamExporter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.fs.FileNameProducer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.impl.xml.exporting.WorkspaceSystemViewStreamExporter;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.SAXException;

public class AIOBackupMigrationService {
    public static final String KNOWLEDGE_WS_NAME = "knowledge";
    private static final String SYSTEM_WS_NAME = "system";
    private static final String COLLABORATION_WS_NAME = "collaboration";
    protected RepositoryService repoService;
    private boolean deleteWCMServicesLogNodes;
    protected static Log log = ExoLogger.getLogger(AIOBackupMigrationService.class);

    public AIOBackupMigrationService(RepositoryService repoService, InitParams initParams) {
        this.repoService = repoService;
        String deleteWCMServicesLogNodes = initParams.getValueParam("delete.wcm.services.log.nodes").getValue();
        this.deleteWCMServicesLogNodes = Boolean.parseBoolean(deleteWCMServicesLogNodes);
    }

    public final int getType() {
        return 1;
    }

    protected URL createStorage(BackupConfig config, Calendar timeStamp) throws FileNotFoundException, IOException {
        FileNameProducer fnp = new FileNameProducer(config.getRepository(), config.getWorkspace(), config.getBackupDir().getAbsolutePath(), timeStamp, true);
        return new URL("file:" + fnp.getNextFile().getAbsolutePath());
    }

    public void startBackupWorkspace(final BackupConfig config) {
        new Thread(){

            public void run() {
                try {
                    log.info((Object)(config.getWorkspace() + " backup init!"));
                    Calendar timeStamp = Calendar.getInstance();
                    URL url = AIOBackupMigrationService.this.createStorage(config, timeStamp);
                    FileOutputStream fos = new FileOutputStream(url.getFile());
                    AIOBackupMigrationService.this.exportWorkspace(fos, config.getRepository(), config.getWorkspace(), false, false);
                    fos.close();
                    log.info((Object)(config.getWorkspace() + " backup done successfully!"));
                }
                catch (RepositoryException e) {
                    log.error((Object)"Full backup initialization failed ", (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Full backup failed for workspace : " + config.getWorkspace()), (Throwable)e);
                }
            }
        }.start();
    }

    private void exportWorkspace(OutputStream out, String repositoryName, String workspaceName, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        try {
            String effectiveWorkspaceName = workspaceName;
            if (workspaceName.equals(KNOWLEDGE_WS_NAME)) {
                effectiveWorkspaceName = COLLABORATION_WS_NAME;
            }
            ManageableRepository repository = this.repoService.getRepository(repositoryName);
            SessionImpl session = (SessionImpl)repository.getSystemSession(effectiveWorkspaceName);
            WorkspaceContainerFacade workspaceContainer = repository.getWorkspaceContainer(effectiveWorkspaceName);
            LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponent(LocalWorkspaceDataManagerStub.class);
            SessionDataManager dataManager = new SessionDataManager(session, workspaceDataManager);
            LocationFactory factory = new LocationFactory((NamespaceAccessor)((NamespaceRegistryImpl)repository.getNamespaceRegistry()));
            WorkspaceEntry wsConfig = (WorkspaceEntry)workspaceContainer.getComponent(WorkspaceEntry.class);
            WorkspaceFileCleanerHolder cleanerHolder = (WorkspaceFileCleanerHolder)workspaceContainer.getComponent(WorkspaceFileCleanerHolder.class);
            ValueFactoryImpl valueFactoryImpl = new ValueFactoryImpl(factory, wsConfig, cleanerHolder);
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(out, "UTF-8");
            WorkspaceSystemViewStreamExporter exporter = null;
            if (workspaceName.equals(COLLABORATION_WS_NAME)) {
                exporter = new CollaborationWorkspaceStreamExporter(streamWriter, (ItemDataConsumer)dataManager, repository.getNamespaceRegistry(), valueFactoryImpl, skipBinary, noRecurse, this.deleteWCMServicesLogNodes);
            } else if (workspaceName.equals(SYSTEM_WS_NAME)) {
                exporter = new SystemWorkspaceStreamExporter(streamWriter, (ItemDataConsumer)dataManager, repository.getNamespaceRegistry(), valueFactoryImpl, skipBinary, noRecurse);
            } else if (workspaceName.equals(KNOWLEDGE_WS_NAME)) {
                exporter = new KnowledgeWorkspaceStreamExporter(streamWriter, (ItemDataConsumer)dataManager, repository.getNamespaceRegistry(), valueFactoryImpl, skipBinary, noRecurse);
            } else {
                throw new RuntimeException("Unknown Workspace name. No backup Job launched for workspace : " + workspaceName);
            }
            ItemData srcItemData = dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            if (srcItemData == null) {
                throw new PathNotFoundException("Root node not found");
            }
            exporter.export((NodeData)srcItemData);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)"Full backup initialization failed ", (Throwable)e);
        }
    }
}

