/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.TemplateConfig;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageViewsHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository";
    private static final String GTMPL_EXTENSION = ".gtmpl";
    private static final String TEMPLATES_LOCATION = "templates/";
    private static final String CB_PATH_TEMPLATE = "pathTemplate".intern();
    private static final String CB_QUERY_TEMPLATE = "queryTemplate".intern();
    private static final String CB_DETAIL_VIEW_TEMPLATE = "detailViewTemplate".intern();
    private static final String CB_SCRIPT_TEMPLATE = "scriptTemplate".intern();
    private static final String ECM_EXPLORER_TEMPLATE = "ecmExplorerTemplate".intern();
    private static final String EXO_PERMISSIONS = "exo:accessPermissions".intern();
    private static final String BUTTON_PROP = "exo:buttons".intern();
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public ManageViewsHandler() {
        super.setTargetComponentName(ManageViewService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Session dmsWorkspaceSession = null;
        try {
            ValueParam valueParam;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, ManageViewPlugin.class);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("addPlugins");
            templatesComponentPlugin.setSetMethod("addPlugins");
            templatesComponentPlugin.setType(ManageViewPlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            if (component.getInitParams() != null) {
                valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                String autoCreateInNewRepository = "false";
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = originalParam.getValue();
                }
                valueParam.setValue(autoCreateInNewRepository);
                templatesPluginInitParams.addParam((Object)valueParam);
            }
            valueParam = new ValueParam();
            valueParam.setName("predefinedViewsLocation");
            valueParam.setValue(TEMPLATES_LOCATION);
            templatesPluginInitParams.addParam((Object)valueParam);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            valueParam = new ValueParam();
            valueParam.setName("repository");
            valueParam.setValue(defaumtRepositoryName);
            templatesPluginInitParams.addParam((Object)valueParam);
            componentPluginsList.add(templatesComponentPlugin);
            DMSConfiguration dmsConfiguration = (DMSConfiguration)container.getComponentInstanceOfType(DMSConfiguration.class);
            String dmsSystemWorkspace = dmsConfiguration.getConfig(defaumtRepositoryName).getSystemWorkspace();
            NodeHierarchyCreator hierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            dmsWorkspaceSession = repository.getSystemSession(dmsSystemWorkspace);
            this.extractTemplates(zos, templatesPluginInitParams, repository, dmsWorkspaceSession, hierarchyCreator, ECM_EXPLORER_TEMPLATE, "ecmExplorerTemplates", "");
            this.extractTemplates(zos, templatesPluginInitParams, repository, dmsWorkspaceSession, hierarchyCreator, CB_DETAIL_VIEW_TEMPLATE, "cbDetaiViewTemplates", "content-browser/");
            this.extractTemplates(zos, templatesPluginInitParams, repository, dmsWorkspaceSession, hierarchyCreator, CB_PATH_TEMPLATE, "cbPathTemplates", "content-browser/");
            this.extractTemplates(zos, templatesPluginInitParams, repository, dmsWorkspaceSession, hierarchyCreator, CB_QUERY_TEMPLATE, "cbQueryTemplates", "content-browser/");
            this.extractTemplates(zos, templatesPluginInitParams, repository, dmsWorkspaceSession, hierarchyCreator, CB_SCRIPT_TEMPLATE, "cbScriptTemplates", "content-browser/");
            List<ViewConfig> viewConfigList = this.getAllViews(defaumtRepositoryName, hierarchyCreator, dmsWorkspaceSession);
            for (ViewConfig viewConfig : viewConfigList) {
                ObjectParameter objectParam = new ObjectParameter();
                objectParam.setName(viewConfig.getName());
                objectParam.setObject((Object)viewConfig);
                templatesPluginInitParams.addParam((Object)objectParam);
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    public List<ViewConfig> getAllViews(String repository, NodeHierarchyCreator hierarchyCreator, Session dmsWorkspaceSession) throws Exception {
        ArrayList<ViewConfig> viewList = new ArrayList<ViewConfig>();
        ViewConfig view = null;
        Node viewNode = null;
        String viewsPath = hierarchyCreator.getJcrPath("userViewsPath");
        try {
            Node viewHome = (Node)dmsWorkspaceSession.getItem(viewsPath);
            NodeIterator iter = viewHome.getNodes();
            while (iter.hasNext()) {
                view = new ViewConfig();
                viewNode = iter.nextNode();
                view.setName(viewNode.getName());
                view.setPermissions(viewNode.getProperty(EXO_PERMISSIONS).getString());
                view.setTemplate(viewNode.getProperty(TemplatePlugin.EXO_TEMPLATE).getString());
                ArrayList<ViewConfig.Tab> tabList = new ArrayList<ViewConfig.Tab>();
                NodeIterator tabsIterator = viewNode.getNodes();
                while (tabsIterator.hasNext()) {
                    Node tabNode = tabsIterator.nextNode();
                    ViewConfig.Tab tab = new ViewConfig.Tab();
                    tab.setTabName(tabNode.getName());
                    if (tabNode.hasProperty(BUTTON_PROP)) {
                        tab.setButtons(tabNode.getProperty(BUTTON_PROP).getString());
                    }
                    tabList.add(tab);
                }
                view.setTabList(tabList);
                viewList.add(view);
            }
        }
        catch (AccessDeniedException ace) {
            return new ArrayList<ViewConfig>();
        }
        return viewList;
    }

    private void extractTemplates(ZipOutputStream zos, InitParams templatesPluginInitParams, ManageableRepository repository, Session dmsWorkspaceSession, NodeHierarchyCreator hierarchyCreator, String type, String basePath, String prefixPath) throws RepositoryException, PathNotFoundException, ValueFormatException, IOException {
        String templatesPath = hierarchyCreator.getJcrPath(basePath);
        Node templatesHome = (Node)dmsWorkspaceSession.getItem(templatesPath);
        NodeIterator ecmExplorerTemplatesIterator = templatesHome.getNodes();
        while (ecmExplorerTemplatesIterator.hasNext()) {
            Node templateNode = ecmExplorerTemplatesIterator.nextNode();
            TemplateConfig templateConfig = new TemplateConfig();
            templateConfig.setName(templateNode.getName());
            templateConfig.setTemplateType(type);
            String templatePath = prefixPath + templatesHome.getName() + "/" + templateNode.getName() + GTMPL_EXTENSION;
            templateConfig.setWarPath(templatePath);
            String template = templateNode.getProperty(TemplatePlugin.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_LOCATION + templatePath));
            zos.write(template.getBytes());
            zos.closeEntry();
            ObjectParameter objectParam = new ObjectParameter();
            objectParam.setName(templateNode.getName());
            objectParam.setObject((Object)templateConfig);
            templatesPluginInitParams.addParam((Object)objectParam);
        }
    }
}

