/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.services.cms.folksonomy.impl.TagStyleConfig;
import org.exoplatform.services.cms.folksonomy.impl.TagStylePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;

public class FolksonomyHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository".intern();
    private static final String RANGE_PROP = "exo:styleRange";
    private static final String HTML_STYLE_PROP = "exo:htmlStyle";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public FolksonomyHandler() {
        super.setTargetComponentName(FolksonomyService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Object dmsWorkspaceSession = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, TagStylePlugin.class);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("query.plugin");
            templatesComponentPlugin.setSetMethod("setQueryPlugin");
            templatesComponentPlugin.setType(TagStylePlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            componentPluginsList.add(templatesComponentPlugin);
            TagStyleConfig tagStyleConfig = new TagStyleConfig();
            ObjectParameter objectParam = new ObjectParameter();
            objectParam.setName("htmStyleForTag.configuration");
            objectParam.setObject((Object)tagStyleConfig);
            templatesPluginInitParams.addParam((Object)objectParam);
            if (component.getInitParams() != null) {
                boolean autoCreateInNewRepository = false;
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = Boolean.parseBoolean(originalParam.getValue());
                }
                tagStyleConfig.setAutoCreatedInNewRepository(autoCreateInNewRepository);
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            tagStyleConfig.setRepository(defaumtRepositoryName);
            ArrayList<TagStyleConfig.HtmlTagStyle> htmlTagStyleList = new ArrayList<TagStyleConfig.HtmlTagStyle>();
            tagStyleConfig.setTagStyleList(htmlTagStyleList);
            FolksonomyService folksonomyService = (FolksonomyService)container.getComponentInstanceOfType(FolksonomyService.class);
            List tagStyleNodes = folksonomyService.getAllTagStyle(defaumtRepositoryName);
            for (Node node : tagStyleNodes) {
                TagStyleConfig.HtmlTagStyle htmlTagStyle = new TagStyleConfig.HtmlTagStyle();
                htmlTagStyle.setName(node.getName());
                htmlTagStyle.setHtmlStyle(this.getHtmlStyleOfStyle(node));
                htmlTagStyle.setTagRate(this.getRangeOfStyle(node));
                htmlTagStyleList.add(htmlTagStyle);
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.XML);
            entry.setContent(this.toXML(configuration));
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    public String getRangeOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(RANGE_PROP).getValue().getString();
    }

    public String getHtmlStyleOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(HTML_STYLE_PROP).getValue().getString();
    }
}

