/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.plf.handler.impl;

import java.util.List;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApplicationRegistryHandler
extends ComponentHandler {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public ApplicationRegistryHandler(InitParams initParams) {
        super.setTargetComponentName(ApplicationRegistryService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        try {
            this.preMarshallComponent(component, container);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            byte[] bytes = this.toXML(configuration);
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.XML);
            entry.setContent(bytes);
            return entry;
        }
        catch (Exception e) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)e);
            return null;
        }
    }

    private void preMarshallComponent(Component component, ExoContainer container) throws Exception {
        ApplicationRegistryService applicationRegistryService = (ApplicationRegistryService)container.getComponentInstanceOfType(ApplicationRegistryService.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handler invoked for component: " + component.getKey() + " of type: " + applicationRegistryService.getClass().getName()));
        }
        List componentPlugins = component.getComponentPlugins();
        for (ComponentPlugin componentPlugin : componentPlugins) {
            if (!componentPlugin.getType().equals("org.exoplatform.application.registry.ApplicationCategoriesPlugins")) continue;
            componentPlugin.getInitParams().clear();
            List applicationCategories = applicationRegistryService.getApplicationCategories();
            for (ApplicationCategory applicationCategory : applicationCategories) {
                ObjectParameter objectParameter = new ObjectParameter();
                ApplicationType[] appTypes = new ApplicationType[]{ApplicationType.PORTLET, ApplicationType.GADGET};
                applicationCategory.setApplications(applicationRegistryService.getApplications(applicationCategory, appTypes));
                objectParameter.setDescription(applicationCategory.getDescription());
                objectParameter.setName(applicationCategory.getName());
                objectParameter.setObject((Object)applicationCategory);
                componentPlugin.getInitParams().addParameter((Parameter)objectParameter);
            }
        }
    }
}

