/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.handlers.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.platform.migration.handlers.ComponentHandler;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class BackupWorkspaceHandler
implements ComponentHandler {
    private PortalContainer portalContainer;
    private RepositoryService repositoryService;
    private BackupManager backupManager;
    private Log log = ExoLogger.getLogger(this.getClass());

    public void invoke(Component component, String rootConfDir) {
        try {
            this.portalContainer = PortalContainer.getInstance();
            this.repositoryService = (RepositoryService)this.portalContainer.getComponentInstanceOfType(RepositoryService.class);
            this.backupManager = (BackupManager)this.portalContainer.getComponentInstanceOfType(BackupManager.class);
            this.preMarshallComponent(component, rootConfDir);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            this.marshall(configuration, rootConfDir + File.separator + "portal" + File.separator + component.getKey() + ".xml");
        }
        catch (Exception ie) {
            this.log.error((Object)"error in the invoke method", (Throwable)ie);
        }
    }

    private void preMarshallComponent(Component component, String rootConfDir) {
        try {
            String[] workspaceNames;
            String backupPath = rootConfDir + File.separator + "backup";
            File backupDirectory = new File(backupPath);
            backupDirectory.mkdirs();
            for (String workspaceName : workspaceNames = this.repositoryService.getCurrentRepository().getWorkspaceNames()) {
                BackupConfig config = new BackupConfig();
                config.setBuckupType(1);
                config.setRepository(this.repositoryService.getCurrentRepository().getConfiguration().getName());
                config.setWorkspace(workspaceName);
                config.setBackupDir(backupDirectory);
                config.setIncrementalJobPeriod(5000L);
                this.backupManager.startBackup(config);
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"problem in the preMarshall Process", (Throwable)ie);
        }
    }

    private void marshall(Object obj, String xmlPath) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(xmlPath));
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot convert the object to xml", (Throwable)ie);
        }
    }
}

