/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.handlers.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.platform.migration.handlers.ComponentHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class ResourceBundleHandler
implements ComponentHandler {
    private PortalContainer portalContainer;
    private ResourceBundleService resourceBundleService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public void invoke(Component component, String rootConfDir) {
        try {
            this.portalContainer = PortalContainer.getInstance();
            this.resourceBundleService = (ResourceBundleService)this.portalContainer.getComponentInstanceOfType(ResourceBundleService.class);
            this.preMarshallComponent(component, rootConfDir);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            this.marshall(configuration, rootConfDir + File.separator + "portal" + File.separator + component.getKey() + ".xml");
        }
        catch (Exception ie) {
            this.log.error((Object)"error in the invoke method", (Throwable)ie);
        }
    }

    private void preMarshallComponent(Component component, String rootConfDir) {
        try {
            String portalConfDir = rootConfDir + File.separator + "portal";
            Query query_ = new Query(null, null);
            PageList pageList = this.resourceBundleService.findResourceDescriptions(query_);
            List dataList = pageList.getAll();
            ArrayList<String> resourcesNames = new ArrayList<String>();
            for (ResourceBundleData rsrcBundleData : dataList) {
                resourcesNames.add(rsrcBundleData.getName());
                String[] tabName = rsrcBundleData.getName().split("\\.");
                String localeConfDir = portalConfDir;
                int i = 0;
                while (i + 1 < tabName.length) {
                    localeConfDir = localeConfDir + File.separator + tabName[i];
                    ++i;
                }
                File localeConfFolder = new File(localeConfDir);
                localeConfFolder.mkdirs();
                File file = new File(localeConfDir + File.separator + tabName[tabName.length - 1] + "_" + rsrcBundleData.getLanguage() + ".properties");
                this.setContents(file, rsrcBundleData.getData());
            }
            ValuesParam initResources = component.getInitParams().getValuesParam("init.resources");
            ArrayList initValues = initResources.getValues();
            ValuesParam portalResources = component.getInitParams().getValuesParam("portal.resource.names");
            ArrayList portalValues = portalResources.getValues();
            ArrayList values = new ArrayList();
            values.addAll(initValues);
            values.addAll(portalValues);
            for (String name : resourcesNames) {
                boolean nameExist = false;
                for (String value : values) {
                    if (!value.equals(name)) continue;
                    nameExist = true;
                }
                if (nameExist) continue;
                initValues.add(name);
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"problem in the preMarshall Process", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContents(File file, String data) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            bw.write(data);
        }
        catch (Exception ie) {
            this.log.error((Object)"File cannot be written: ", (Throwable)ie);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    private void marshall(Object obj, String xmlPath) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(xmlPath));
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot convert the object to xml", (Throwable)ie);
        }
    }
}

