/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.AckMcastSenderWindow;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.StaticInterval;

public class AckMcastSenderWindowTest
extends TestCase {
    private static Address[] _RECVS = new Address[]{new IpAddress(5000), new IpAddress(5001), new IpAddress(5002)};
    private AckMcastSenderWindow.RetransmitCommand _cmd;
    private AckMcastSenderWindow _win;
    private final Hashtable _tbl = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _put(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            ArrayList<Address> list = (ArrayList<Address>)this._tbl.get(new Long(seqno));
            if (list == null) {
                list = new ArrayList<Address>();
                this._tbl.put(new Long(seqno), list);
            }
            if (!list.contains(addr)) {
                list.add(addr);
            } else if (list.isEmpty()) {
                this._tbl.remove(new Long(seqno));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _remove(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            List list = (List)this._tbl.get(new Long(seqno));
            if (list == null) {
                return;
            }
            list.remove(addr);
            if (list.isEmpty()) {
                this._tbl.remove(new Long(seqno));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _contains(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            List list = (List)this._tbl.get(new Long(seqno));
            if (list == null) {
                return false;
            }
            return list.contains(addr);
        }
    }

    private void _ackerRun() {
        this._win.ack(2L, _RECVS[2]);
        this._remove(2L, _RECVS[2]);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[1]);
        this._remove(1L, _RECVS[1]);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[0]);
        this._remove(1L, _RECVS[0]);
        this._win.ack(2L, _RECVS[0]);
        this._remove(2L, _RECVS[0]);
        this._win.ack(2L, _RECVS[1]);
        this._remove(2L, _RECVS[1]);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[2]);
        this._remove(1L, _RECVS[2]);
    }

    private void _retransmit(long seqno, Message msg, Address addr) {
        if (!this._contains(seqno, addr)) {
            AckMcastSenderWindowTest.fail((String)"Acknowledging a non-existent msg, great!");
        } else {
            System.out.println("retransmitting " + seqno + ", msg=" + msg);
        }
    }

    public void test1() {
        int i;
        Vector<Address> dests = new Vector<Address>();
        Message msg = new Message();
        Acker acker = new Acker();
        dests.addAll(Arrays.asList(_RECVS));
        long seqno = 1L;
        for (i = 0; i < _RECVS.length; ++i) {
            this._put(seqno, _RECVS[i]);
        }
        this._win.add(seqno, msg, dests);
        seqno = 2L;
        for (i = 0; i < _RECVS.length; ++i) {
            this._put(seqno, _RECVS[i]);
        }
        this._win.add(seqno, msg, dests);
        acker.start();
        try {
            acker.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.stop();
    }

    public void testRemove() throws UnknownHostException {
        AckMcastSenderWindow mywin = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)new MyCommand(), new StaticInterval(1000L, 2000L, 3000L));
        IpAddress sender1 = new IpAddress("127.0.0.1", 10000);
        IpAddress sender2 = new IpAddress("127.0.0.1", 10001);
        IpAddress sender3 = new IpAddress("127.0.0.1", 10002);
        Vector<IpAddress> senders = new Vector<IpAddress>();
        Message msg = new Message();
        long seqno = 322649L;
        senders.addElement(sender1);
        senders.addElement(sender2);
        senders.addElement(sender3);
        mywin.add(seqno, msg, (Vector)senders.clone());
        mywin.ack(seqno, sender1);
        mywin.ack(seqno, sender2);
        System.out.println("entry is " + mywin.printDetails(seqno));
        AckMcastSenderWindowTest.assertEquals((long)3L, (long)mywin.getNumberOfResponsesExpected(seqno));
        AckMcastSenderWindowTest.assertEquals((long)2L, (long)mywin.getNumberOfResponsesReceived(seqno));
        mywin.waitUntilAllAcksReceived(4000L);
        mywin.suspect(sender3);
        AckMcastSenderWindowTest.assertEquals((long)0L, (long)mywin.size());
    }

    public AckMcastSenderWindowTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this._cmd = new Cmd();
        this._win = new AckMcastSenderWindow(this._cmd);
    }

    public void tearDown() throws Exception {
        this._win.stop();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AckMcastSenderWindowTest.class);
        return suite;
    }

    public static void main(String[] args) {
        String[] name = new String[]{AckMcastSenderWindowTest.class.getName()};
        TestRunner.main((String[])name);
    }

    static class MyCommand
    implements AckMcastSenderWindow.RetransmitCommand {
        MyCommand() {
        }

        public void retransmit(long seqno, Message msg, Address dest) {
            System.out.println("-- retransmitting " + seqno);
        }
    }

    private class Acker
    extends Thread {
        private Acker() {
        }

        public void run() {
            AckMcastSenderWindowTest.this._ackerRun();
        }
    }

    private class Cmd
    implements AckMcastSenderWindow.RetransmitCommand {
        private Cmd() {
        }

        public void retransmit(long seqno, Message msg, Address addr) {
            AckMcastSenderWindowTest.this._retransmit(seqno, msg, addr);
        }
    }
}

