/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.LazyObjectLoader;
import org.icepdf.core.util.MemoryManager;

public class Library {
    private static final Logger log = Logger.getLogger(Library.class.toString());
    private LazyObjectLoader m_LazyObjectLoader;
    private ConcurrentHashMap<Reference, Object> refs = new ConcurrentHashMap(1024);
    private ConcurrentHashMap<Reference, ICCBased> lookupReference2ICCBased = new ConcurrentHashMap(256);
    private Catalog catalog;
    public MemoryManager memoryManager = MemoryManager.getInstance();
    public CacheManager cacheManager = new CacheManager();
    public SecurityManager securityManager;
    public StateManager stateManager;
    private boolean isEncrypted;
    private boolean isLinearTraversal;

    public void setLazyObjectLoader(LazyObjectLoader lol) {
        this.m_LazyObjectLoader = lol;
        if (this.m_LazyObjectLoader != null) {
            this.memoryManager.registerMemoryManagerDelegate(this.m_LazyObjectLoader);
        }
    }

    public PTrailer getTrailerByFilePosition(long position) {
        if (this.m_LazyObjectLoader == null) {
            return null;
        }
        return this.m_LazyObjectLoader.loadTrailer(position);
    }

    public Object getObject(Reference reference) {
        Object ob;
        while (true) {
            if ((ob = this.refs.get(reference)) == null && this.m_LazyObjectLoader != null && this.m_LazyObjectLoader.loadObject(reference)) {
                ob = this.refs.get(reference);
            }
            if (ob == null || !(ob instanceof Reference)) break;
            reference = (Reference)ob;
        }
        return ob;
    }

    private void printObjectDebug(Object ob) {
        if (ob == null) {
            log.finer("null object found");
        } else if (ob instanceof PObject) {
            PObject tmp = (PObject)ob;
            log.finer(tmp.getReference() + " " + tmp.toString());
        } else if (ob instanceof Dictionary) {
            Dictionary tmp = (Dictionary)ob;
            log.finer(tmp.getPObjectReference() + " " + tmp.toString());
        } else {
            log.finer(ob.getClass() + " " + ob.toString());
        }
    }

    public Object getObject(Hashtable dictionaryEntries, String key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object o = dictionaryEntries.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Reference) {
            o = this.getObject((Reference)o);
        }
        return o;
    }

    public boolean isReference(Hashtable dictionaryEntries, String key) {
        return dictionaryEntries != null && dictionaryEntries.get(key) instanceof Reference;
    }

    public Reference getReference(Hashtable dictionaryEntries, String key) {
        Object ref = dictionaryEntries.get(key);
        if (ref instanceof Reference) {
            return (Reference)ref;
        }
        return null;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public Object getObject(Object referenceObject) {
        if (referenceObject instanceof Reference) {
            return this.getObject((Reference)referenceObject);
        }
        return referenceObject;
    }

    public boolean isValidEntry(Hashtable dictionaryEntries, String key) {
        if (dictionaryEntries == null) {
            return false;
        }
        Object o = dictionaryEntries.get(key);
        return o != null && (!(o instanceof Reference) || this.isValidEntry((Reference)o));
    }

    public boolean isValidEntry(Reference reference) {
        Object ob = this.refs.get(reference);
        return ob != null || this.m_LazyObjectLoader != null && this.m_LazyObjectLoader.haveEntry(reference);
    }

    public Number getNumber(Hashtable dictionaryEntries, String key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    public Boolean getBoolean(Hashtable dictionaryEntries, String key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return o instanceof Boolean && (Boolean)o != false;
    }

    public float getFloat(Hashtable dictionaryEntries, String key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.floatValue() : 0.0f;
    }

    public int getInt(Hashtable dictionaryEntries, String key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.intValue() : 0;
    }

    public long getLong(Hashtable dictionaryEntries, String key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.longValue() : 0L;
    }

    public String getName(Hashtable dictionaryEntries, String key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o != null && o instanceof Name) {
            return ((Name)o).getName();
        }
        return null;
    }

    public Hashtable getDictionary(Hashtable dictionaryEntries, String key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof Hashtable) {
            return (Hashtable)o;
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            Hashtable h1 = new Hashtable();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Object o1 = e.nextElement();
                if (!(o1 instanceof Map)) continue;
                h1.putAll((Map)o1);
            }
            return h1;
        }
        return null;
    }

    public Rectangle2D.Float getRectangle(Hashtable dictionaryEntries, String key) {
        Vector v = (Vector)this.getObject(dictionaryEntries, key);
        if (v != null) {
            return new PRectangle(v).toJava2dCoordinates();
        }
        return null;
    }

    public ICCBased getICCBased(Reference ref) {
        Object obj;
        ICCBased cs = this.lookupReference2ICCBased.get(ref);
        if (cs == null && (obj = this.getObject(ref)) instanceof Stream) {
            Stream stream = (Stream)obj;
            cs = new ICCBased(this, stream);
            this.lookupReference2ICCBased.put(ref, cs);
        }
        return cs;
    }

    public Resources getResources(Hashtable dictionaryEntries, String key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object ob = dictionaryEntries.get(key);
        if (ob == null) {
            return null;
        }
        if (ob instanceof Resources) {
            return (Resources)ob;
        }
        if (ob instanceof Reference) {
            Reference reference = (Reference)ob;
            return this.getResources(reference);
        }
        if (ob instanceof Hashtable) {
            Hashtable ht = (Hashtable)ob;
            Resources resources = new Resources(this, ht);
            dictionaryEntries.put(key, resources);
            return resources;
        }
        return null;
    }

    public Resources getResources(Reference reference) {
        Object ob;
        while (true) {
            if ((ob = this.refs.get(reference)) == null && this.m_LazyObjectLoader != null && this.m_LazyObjectLoader.loadObject(reference)) {
                ob = this.refs.get(reference);
            }
            if (ob == null) {
                return null;
            }
            if (ob instanceof Resources) {
                return (Resources)ob;
            }
            if (!(ob instanceof Reference)) break;
            reference = (Reference)ob;
        }
        if (ob instanceof Hashtable) {
            Hashtable ht = (Hashtable)ob;
            Resources resources = new Resources(this, ht);
            this.addObject(resources, reference);
            return resources;
        }
        return null;
    }

    public void addObject(Object object, Reference objectReference) {
        this.refs.put(objectReference, object);
    }

    public void removeObject(Reference objetReference) {
        if (objetReference != null) {
            this.refs.remove(objetReference);
        }
    }

    public Reference getObjectReference(Hashtable dictionaryEntries, String key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object o = dictionaryEntries.get(key);
        if (o == null) {
            return null;
        }
        Reference currentRef = null;
        while (o != null && o instanceof Reference) {
            currentRef = (Reference)o;
            o = this.getObject(currentRef);
        }
        return currentRef;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setEncrypted(boolean flag) {
        this.isEncrypted = flag;
    }

    public void setLinearTraversal() {
        this.isLinearTraversal = true;
    }

    public boolean isLinearTraversal() {
        return this.isLinearTraversal;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog c) {
        this.catalog = c;
    }

    public void disposeFontResources() {
        Enumeration<Reference> test = this.refs.keys();
        while (test.hasMoreElements()) {
            Reference ref = test.nextElement();
            Object tmp = this.refs.get(ref);
            if (!(tmp instanceof Font) && !(tmp instanceof FontDescriptor)) continue;
            this.refs.remove(ref);
        }
    }

    public void dispose() {
        if (this.memoryManager != null) {
            this.memoryManager.releaseAllByLibrary(this);
        }
        if (this.cacheManager != null) {
            this.cacheManager.dispose();
        }
        if (this.refs != null) {
            this.refs.clear();
        }
        if (this.lookupReference2ICCBased != null) {
            this.lookupReference2ICCBased.clear();
            this.lookupReference2ICCBased = null;
        }
        if (this.m_LazyObjectLoader != null) {
            this.m_LazyObjectLoader.dispose();
        }
    }
}

