/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.text;

import java.io.IOException;
import java.util.ArrayList;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionFlags;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.text.TextRegionFlags;
import org.jpedal.jbig2.segment.region.text.TextRegionHuffmanFlags;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionarySegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class TextRegionSegment
extends RegionSegment {
    private TextRegionFlags textRegionFlags = new TextRegionFlags();
    private TextRegionHuffmanFlags textRegionHuffmanFlags = new TextRegionHuffmanFlags();
    private int noOfSymbolInstances;
    private boolean inlineImage;
    private short[] symbolRegionAdaptiveTemplateX = new short[2];
    private short[] symbolRegionAdaptiveTemplateY = new short[2];

    public TextRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    public void readSegment() throws IOException, JBIG2Exception {
        if (JBIG2StreamDecoder.debug) {
            System.out.println("==== Reading Text Region ====");
        }
        super.readSegment();
        this.readTextRegionFlags();
        short[] buff = new short[4];
        this.decoder.readByte(buff);
        this.noOfSymbolInstances = BinaryOperation.getInt32(buff);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("noOfSymbolInstances = " + this.noOfSymbolInstances);
        }
        int noOfReferredToSegments = this.segmentHeader.getReferredToSegmentCount();
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        ArrayList<Segment> codeTables = new ArrayList<Segment>();
        ArrayList<Segment> segmentsReferenced = new ArrayList<Segment>();
        int noOfSymbols = 0;
        if (JBIG2StreamDecoder.debug) {
            System.out.println("noOfReferredToSegments = " + noOfReferredToSegments);
        }
        for (int i = 0; i < noOfReferredToSegments; ++i) {
            Segment seg = this.decoder.findSegment(referredToSegments[i]);
            int type = seg.getSegmentHeader().getSegmentType();
            if (type == 0) {
                segmentsReferenced.add(seg);
                noOfSymbols += ((SymbolDictionarySegment)seg).getNoOfExportedSymbols();
                continue;
            }
            if (type != 53) continue;
            codeTables.add(seg);
        }
        int symbolCodeLength = 0;
        for (int count = 1; count < noOfSymbols; count <<= 1) {
            ++symbolCodeLength;
        }
        int currentSymbol = 0;
        JBIG2Bitmap[] symbols = new JBIG2Bitmap[noOfSymbols];
        for (Segment seg : segmentsReferenced) {
            if (seg.getSegmentHeader().getSegmentType() != 0) continue;
            JBIG2Bitmap[] bitmaps = ((SymbolDictionarySegment)seg).getBitmaps();
            for (int j = 0; j < bitmaps.length; ++j) {
                symbols[currentSymbol] = bitmaps[j];
                ++currentSymbol;
            }
        }
        int[][] huffmanFSTable = null;
        int[][] huffmanDSTable = null;
        int[][] huffmanDTTable = null;
        int[][] huffmanRDWTable = null;
        int[][] huffmanRDHTable = null;
        int[][] huffmanRDXTable = null;
        int[][] huffmanRDYTable = null;
        int[][] huffmanRSizeTable = null;
        boolean sbHuffman = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_HUFF) != 0;
        int i = 0;
        if (sbHuffman) {
            int sbHuffFS = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_FS);
            if (sbHuffFS == 0) {
                huffmanFSTable = HuffmanDecoder.huffmanTableF;
            } else if (sbHuffFS == 1) {
                huffmanFSTable = HuffmanDecoder.huffmanTableG;
            }
            int sbHuffDS = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_DS);
            if (sbHuffDS == 0) {
                huffmanDSTable = HuffmanDecoder.huffmanTableH;
            } else if (sbHuffDS == 1) {
                huffmanDSTable = HuffmanDecoder.huffmanTableI;
            } else if (sbHuffDS == 2) {
                huffmanDSTable = HuffmanDecoder.huffmanTableJ;
            }
            int sbHuffDT = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_DT);
            if (sbHuffDT == 0) {
                huffmanDTTable = HuffmanDecoder.huffmanTableK;
            } else if (sbHuffDT == 1) {
                huffmanDTTable = HuffmanDecoder.huffmanTableL;
            } else if (sbHuffDT == 2) {
                huffmanDTTable = HuffmanDecoder.huffmanTableM;
            }
            int sbHuffRDW = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_RDW);
            if (sbHuffRDW == 0) {
                huffmanRDWTable = HuffmanDecoder.huffmanTableN;
            } else if (sbHuffRDW == 1) {
                huffmanRDWTable = HuffmanDecoder.huffmanTableO;
            }
            int sbHuffRDH = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_RDH);
            if (sbHuffRDH == 0) {
                huffmanRDHTable = HuffmanDecoder.huffmanTableN;
            } else if (sbHuffRDH == 1) {
                huffmanRDHTable = HuffmanDecoder.huffmanTableO;
            }
            int sbHuffRDX = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_RDX);
            if (sbHuffRDX == 0) {
                huffmanRDXTable = HuffmanDecoder.huffmanTableN;
            } else if (sbHuffRDX == 1) {
                huffmanRDXTable = HuffmanDecoder.huffmanTableO;
            }
            int sbHuffRDY = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_RDY);
            if (sbHuffRDY == 0) {
                huffmanRDYTable = HuffmanDecoder.huffmanTableN;
            } else if (sbHuffRDY == 1) {
                huffmanRDYTable = HuffmanDecoder.huffmanTableO;
            }
            int sbHuffRSize = this.textRegionHuffmanFlags.getFlagValue(TextRegionHuffmanFlags.SB_HUFF_RSIZE);
            if (sbHuffRSize == 0) {
                huffmanRSizeTable = HuffmanDecoder.huffmanTableA;
            }
        }
        int[][] runLengthTable = new int[36][4];
        int[][] symbolCodeTable = new int[noOfSymbols + 1][4];
        if (sbHuffman) {
            this.decoder.consumeRemainingBits();
            for (i = 0; i < 32; ++i) {
                runLengthTable[i] = new int[]{i, this.decoder.readBits(4), 0, 0};
            }
            runLengthTable[32] = new int[]{259, this.decoder.readBits(4), 2, 0};
            runLengthTable[33] = new int[]{515, this.decoder.readBits(4), 3, 0};
            runLengthTable[34] = new int[]{523, this.decoder.readBits(4), 7, 0};
            runLengthTable[35] = new int[]{0, 0, HuffmanDecoder.jbig2HuffmanEOT};
            runLengthTable = HuffmanDecoder.buildTable(runLengthTable, 35);
            for (i = 0; i < noOfSymbols; ++i) {
                symbolCodeTable[i] = new int[]{i, 0, 0, 0};
            }
            i = 0;
            while (i < noOfSymbols) {
                int j = this.huffmanDecoder.decodeInt(runLengthTable).intResult();
                if (j > 512) {
                    j -= 512;
                    while (j != 0 && i < noOfSymbols) {
                        symbolCodeTable[i++][1] = 0;
                        --j;
                    }
                    continue;
                }
                if (j > 256) {
                    j -= 256;
                    while (j != 0 && i < noOfSymbols) {
                        symbolCodeTable[i][1] = symbolCodeTable[i - 1][1];
                        ++i;
                        --j;
                    }
                    continue;
                }
                symbolCodeTable[i++][1] = j;
            }
            symbolCodeTable[noOfSymbols][1] = 0;
            symbolCodeTable[noOfSymbols][2] = HuffmanDecoder.jbig2HuffmanEOT;
            symbolCodeTable = HuffmanDecoder.buildTable(symbolCodeTable, noOfSymbols);
            this.decoder.consumeRemainingBits();
        } else {
            symbolCodeTable = null;
            this.arithmeticDecoder.resetIntStats(symbolCodeLength);
            this.arithmeticDecoder.start();
        }
        boolean symbolRefine = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_REFINE) != 0;
        int logStrips = this.textRegionFlags.getFlagValue(TextRegionFlags.LOG_SB_STRIPES);
        int defaultPixel = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_DEF_PIXEL);
        int combinationOperator = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_COMB_OP);
        boolean transposed = this.textRegionFlags.getFlagValue(TextRegionFlags.TRANSPOSED) != 0;
        int referenceCorner = this.textRegionFlags.getFlagValue(TextRegionFlags.REF_CORNER);
        int sOffset = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_DS_OFFSET);
        int template = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_R_TEMPLATE);
        if (symbolRefine) {
            this.arithmeticDecoder.resetRefinementStats(template, null);
        }
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        bitmap.readTextRegion(sbHuffman, symbolRefine, this.noOfSymbolInstances, logStrips, noOfSymbols, symbolCodeTable, symbolCodeLength, symbols, defaultPixel, combinationOperator, transposed, referenceCorner, sOffset, huffmanFSTable, huffmanDSTable, huffmanDTTable, huffmanRDWTable, huffmanRDHTable, huffmanRDXTable, huffmanRDYTable, huffmanRSizeTable, template, this.symbolRegionAdaptiveTemplateX, this.symbolRegionAdaptiveTemplateY, this.decoder);
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegement(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            if (JBIG2StreamDecoder.debug) {
                System.out.println(pageBitmap + " " + bitmap);
            }
            int externalCombinationOperator = this.regionFlags.getFlagValue(RegionFlags.EXTERNAL_COMBINATION_OPERATOR);
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, externalCombinationOperator);
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
        this.decoder.consumeRemainingBits();
    }

    private void readTextRegionFlags() throws IOException {
        boolean sbHuff;
        short[] textRegionFlagsField = new short[2];
        this.decoder.readByte(textRegionFlagsField);
        int flags = BinaryOperation.getInt16(textRegionFlagsField);
        this.textRegionFlags.setFlags(flags);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("text region Segment flags = " + flags);
        }
        boolean bl = sbHuff = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_HUFF) != 0;
        if (sbHuff) {
            short[] textRegionHuffmanFlagsField = new short[2];
            this.decoder.readByte(textRegionHuffmanFlagsField);
            flags = BinaryOperation.getInt16(textRegionHuffmanFlagsField);
            this.textRegionHuffmanFlags.setFlags(flags);
            if (JBIG2StreamDecoder.debug) {
                System.out.println("text region segment Huffman flags = " + flags);
            }
        }
        boolean sbRefine = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_REFINE) != 0;
        int sbrTemplate = this.textRegionFlags.getFlagValue(TextRegionFlags.SB_R_TEMPLATE);
        if (sbRefine && sbrTemplate == 0) {
            this.symbolRegionAdaptiveTemplateX[0] = this.readATValue();
            this.symbolRegionAdaptiveTemplateY[0] = this.readATValue();
            this.symbolRegionAdaptiveTemplateX[1] = this.readATValue();
            this.symbolRegionAdaptiveTemplateY[1] = this.readATValue();
        }
    }

    public TextRegionFlags getTextRegionFlags() {
        return this.textRegionFlags;
    }

    public TextRegionHuffmanFlags getTextRegionHuffmanFlags() {
        return this.textRegionHuffmanFlags;
    }
}

