/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;

public class PropertyDefinitionDatas {
    private PropertyDefinitionData multiDef = null;
    private PropertyDefinitionData singleDef = null;

    public void setDefinition(PropertyDefinitionData def) {
        boolean residual = def.isResidualSet();
        if (def.isMultiple()) {
            if (residual && this.multiDef == null || !residual) {
                this.multiDef = def;
            }
        } else if (residual && this.singleDef == null || !residual) {
            this.singleDef = def;
        }
    }

    public PropertyDefinitionData getDefinition(boolean multiple) {
        this.refresh();
        if (multiple && this.multiDef != null) {
            return this.multiDef;
        }
        if (!multiple && this.singleDef != null) {
            return this.singleDef;
        }
        return null;
    }

    public PropertyDefinitionData getAnyDefinition() {
        this.refresh();
        if (this.multiDef != null) {
            return this.multiDef;
        }
        if (this.singleDef != null) {
            return this.singleDef;
        }
        return null;
    }

    private void refresh() {
        if (this.multiDef != null && this.singleDef != null) {
            if (this.multiDef.isResidualSet() && !this.singleDef.isResidualSet()) {
                this.multiDef = null;
            }
            if (this.singleDef.isResidualSet() && !this.multiDef.isResidualSet()) {
                this.singleDef = null;
            }
        }
    }

    public String dump() {
        return "Definitions single: " + (this.singleDef == null ? "N/D" : this.singleDef.getName()) + ", multiple: " + (this.multiDef == null ? "N/D" : this.multiDef.getName());
    }
}

