/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockData;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockPersister;
import org.exoplatform.services.jcr.impl.core.lock.LockRemover;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.WorkspaceLockManager;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class LockManagerImpl
implements WorkspaceLockManager,
ItemsPersistenceListener,
Startable {
    public static final long DEFAULT_LOCK_TIMEOUT = 1800000L;
    private static final int SEARCH_EXECMATCH = 1;
    private static final int SEARCH_CLOSEDPARENT = 2;
    private static final int SEARCH_CLOSEDCHILD = 4;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LockManagerImpl");
    private final Map<String, LockData> locks;
    private final DataManager dataManager;
    private final Map<String, LockData> pendingLocks;
    private final Map<String, LockData> tokensMap;
    private long lockTimeOut;
    private LockRemover lockRemover;
    private final LockPersister persister;

    public LockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config) {
        this(dataManager, config, null);
    }

    public LockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, LockPersister persister) {
        this.dataManager = dataManager;
        this.persister = persister;
        this.lockTimeOut = config.getLockManager() != null ? (config.getLockManager().getTimeout() > 0L ? config.getLockManager().getTimeout() : 1800000L) : 1800000L;
        this.locks = new HashMap<String, LockData>();
        this.pendingLocks = new HashMap<String, LockData>();
        this.tokensMap = new HashMap<String, LockData>();
        dataManager.addItemPersistenceListener(this);
    }

    public synchronized void addLockToken(String sessionId, String lt) {
        LockData currLock = this.tokensMap.get(lt);
        if (currLock != null) {
            currLock.addLockHolder(sessionId);
        }
    }

    public synchronized Lock addPendingLock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timeOut) throws LockException {
        LockData lData = this.getLockData((NodeData)node.getData(), 3);
        if (lData != null) {
            if (lData.getNodeIdentifier().equals(node.getInternalIdentifier())) {
                throw new LockException("Node already locked: " + node.getData().getQPath());
            }
            if (lData.isDeep()) {
                throw new LockException("Parent node has deep lock.");
            }
        }
        if (isDeep && this.getLockData((NodeData)node.getData(), 4) != null) {
            throw new LockException("Some child node is locked.");
        }
        String lockToken = IdGenerator.generate();
        lData = new LockData(node.getInternalIdentifier(), lockToken, isDeep, isSessionScoped, node.getSession().getUserID(), timeOut > 0L ? timeOut : this.lockTimeOut);
        lData.addLockHolder(node.getSession().getId());
        this.pendingLocks.put(node.getInternalIdentifier(), lData);
        this.tokensMap.put(lockToken, lData);
        LockImpl lock = new LockImpl(node.getSession(), lData);
        return lock;
    }

    public LockImpl getLock(NodeImpl node) throws LockException, RepositoryException {
        LockData lData = this.getLockData((NodeData)node.getData(), 3);
        if (lData == null || !node.getInternalIdentifier().equals(lData.getNodeIdentifier()) && !lData.isDeep()) {
            throw new LockException("Node not locked: " + node.getData().getQPath());
        }
        return new LockImpl(node.getSession(), lData);
    }

    public synchronized String[] getLockTokens(String sessionID) {
        ArrayList<String> retval = new ArrayList<String>();
        for (LockData lockData : this.locks.values()) {
            if (!lockData.isLockHolder(sessionID)) continue;
            retval.add(lockData.getLockToken(sessionID));
        }
        return retval.toArray(new String[retval.size()]);
    }

    public boolean holdsLock(NodeData node) throws RepositoryException {
        return this.getLockData(node, 1) != null;
    }

    public boolean isLocked(NodeData node) {
        LockData lData = this.getLockData(node, 3);
        return lData != null && (node.getIdentifier().equals(lData.getNodeIdentifier()) || lData.isDeep());
    }

    public boolean isLockHolder(NodeData node, String sessionId) {
        LockData lData = this.getLockData(node, 3);
        return lData != null && lData.isLockHolder(sessionId);
    }

    public synchronized void onCloseSession(ExtendedSession session) {
        SessionImpl sessionImpl = (SessionImpl)session;
        Iterator<Map.Entry<String, LockData>> entries = this.locks.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, LockData> entry = entries.next();
            LockData lockData = entry.getValue();
            if (lockData.isLive()) {
                if (!lockData.isLockHolder(session.getId())) continue;
                if (lockData.isSessionScoped()) {
                    try {
                        ((NodeImpl)sessionImpl.getTransientNodesManager().getItemByIdentifier(lockData.getNodeIdentifier(), false)).unlock();
                    }
                    catch (UnsupportedRepositoryOperationException e) {
                        this.log.error((Object)e.getLocalizedMessage());
                    }
                    catch (LockException e) {
                        this.log.error((Object)e.getLocalizedMessage());
                    }
                    catch (AccessDeniedException e) {
                        this.log.error((Object)e.getLocalizedMessage());
                    }
                    catch (RepositoryException e) {
                        this.log.error((Object)e.getLocalizedMessage());
                    }
                    continue;
                }
                lockData.removeLockHolder(session.getId());
                continue;
            }
            entries.remove();
        }
    }

    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        ArrayList<PlainChangesLog> chengesLogList = new ArrayList<PlainChangesLog>();
        if (changesLog instanceof TransactionChangesLog) {
            ChangesLogIterator logIterator = ((TransactionChangesLog)changesLog).getLogIterator();
            while (logIterator.hasNextLog()) {
                chengesLogList.add(logIterator.nextLog());
            }
        } else if (changesLog instanceof PlainChangesLog) {
            chengesLogList.add((PlainChangesLog)changesLog);
        } else if (changesLog instanceof CompositeChangesLog) {
            ChangesLogIterator iter = ((CompositeChangesLog)changesLog).getLogIterator();
            while (iter.hasNextLog()) {
                chengesLogList.add(iter.nextLog());
            }
        }
        block11: for (PlainChangesLog currChangesLog : chengesLogList) {
            try {
                switch (currChangesLog.getEventType()) {
                    case 0x400000: {
                        if (currChangesLog.getSize() < 2) {
                            this.log.error((Object)("Incorrect changes log  of type ExtendedEvent.LOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        String nodeIdentifier = currChangesLog.getAllStates().get(0).getData().getParentIdentifier();
                        if (this.pendingLocks.containsKey(nodeIdentifier)) {
                            this.internalLock(nodeIdentifier);
                            break;
                        }
                        this.log.warn((Object)("No lock in pendingLocks for identifier " + nodeIdentifier + " Probably lock come from replication."));
                        String lockToken = IdGenerator.generate();
                        ItemState ownerState = this.getItemState(currChangesLog, Constants.JCR_LOCKOWNER);
                        ItemState isDeepState = this.getItemState(currChangesLog, Constants.JCR_LOCKISDEEP);
                        if (ownerState == null || isDeepState == null) continue block11;
                        String owner = new String(((PersistedPropertyData)ownerState.getData()).getValues().get(0).getAsByteArray(), "UTF-8");
                        boolean isDeep = Boolean.valueOf(new String(((PersistedPropertyData)isDeepState.getData()).getValues().get(0).getAsByteArray(), "UTF-8"));
                        this.createRemoteLock(currChangesLog.getSessionId(), nodeIdentifier, lockToken, isDeep, false, owner);
                        break;
                    }
                    case 0x800000: {
                        if (currChangesLog.getSize() < 2) {
                            this.log.error((Object)("Incorrect changes log  of type ExtendedEvent.UNLOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        this.internalUnLock(currChangesLog.getSessionId(), currChangesLog.getAllStates().get(0).getData().getParentIdentifier());
                        break;
                    }
                    default: {
                        String nodeIdentifier;
                        HashSet<String> removedLock = new HashSet<String>();
                        for (ItemState itemState : currChangesLog.getAllStates()) {
                            if (!itemState.getData().isNode() || !this.locks.containsKey(itemState.getData().getIdentifier())) continue;
                            nodeIdentifier = itemState.getData().getIdentifier();
                            if (itemState.isDeleted()) {
                                removedLock.add(nodeIdentifier);
                                continue;
                            }
                            if (!itemState.isAdded() && !itemState.isRenamed() && !itemState.isUpdated()) continue;
                            removedLock.remove(nodeIdentifier);
                        }
                        for (String identifier : removedLock) {
                            this.internalUnLock(currChangesLog.getSessionId(), identifier);
                        }
                        continue block11;
                    }
                }
            }
            catch (LockException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void removeLockToken(String sessionId, String lt) {
        LockData lData = this.tokensMap.get(lt);
        if (lData != null && lData.isLockHolder(sessionId)) {
            lData.removeLockHolder(sessionId);
        }
    }

    public void start() {
        this.lockRemover = new LockRemover(this);
    }

    synchronized List<LockData> getLockList() {
        return new ArrayList<LockData>(this.locks.values());
    }

    @Override
    public synchronized void removeExpired() {
        ArrayList<String> removeLockList = new ArrayList<String>();
        for (LockData lock : this.locks.values()) {
            if (lock.isSessionScoped() || lock.getTimeToDeath() >= 0L) continue;
            removeLockList.add(lock.getNodeIdentifier());
        }
        for (String rLock : removeLockList) {
            this.removeLock(rLock);
        }
    }

    public void stop() {
        this.lockRemover.halt();
        this.lockRemover.interrupt();
        this.locks.clear();
        this.pendingLocks.clear();
        this.tokensMap.clear();
    }

    private TransientItemData copyItemData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), prop.getValues());
        return newData;
    }

    private ItemState getItemState(PlainChangesLog changesLog, InternalQName itemName) {
        List<ItemState> allStates = changesLog.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (!state.getData().getQPath().getName().equals((Object)itemName)) continue;
            return state;
        }
        return null;
    }

    private LockData getLockData(NodeData data, int searchType) {
        if (data == null || this.locks.size() == 0) {
            return null;
        }
        LockData retval = null;
        try {
            NodeData parentData;
            if ((searchType & 1) != 0) {
                retval = this.locks.get(data.getIdentifier());
            }
            if (retval == null && (searchType & 2) != 0 && (parentData = (NodeData)this.dataManager.getItemData(data.getParentIdentifier())) != null && (retval = this.locks.get(parentData.getIdentifier())) == null) {
                retval = this.getLockData(parentData, 2);
            }
            if (retval == null && (searchType & 4) != 0) {
                NodeData nodeData;
                List<NodeData> childData = this.dataManager.getChildNodesData(data);
                Iterator<NodeData> i$ = childData.iterator();
                while (i$.hasNext() && (retval = this.locks.get((nodeData = i$.next()).getIdentifier())) == null) {
                }
                if (retval == null) {
                    i$ = childData.iterator();
                    while (i$.hasNext() && (retval = this.getLockData(nodeData = i$.next(), 4)) == null) {
                    }
                }
            }
        }
        catch (RepositoryException e) {
            return null;
        }
        return retval;
    }

    private synchronized void internalLock(String nodeIdentifier) throws LockException {
        LockData ldata = this.pendingLocks.get(nodeIdentifier);
        if (ldata != null) {
            this.locks.put(nodeIdentifier, ldata);
            if (this.persister != null) {
                this.persister.add(ldata);
            }
        } else {
            throw new LockException("No lock in pending locks");
        }
        this.pendingLocks.remove(nodeIdentifier);
    }

    private synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws LockException {
        LockData lData = this.locks.get(nodeIdentifier);
        if (lData != null) {
            this.tokensMap.remove(lData.getLockToken(sessionId));
            this.locks.remove(nodeIdentifier);
            lData.setLive(false);
            if (this.persister != null) {
                this.persister.remove(lData);
            }
            lData = null;
        }
    }

    private synchronized LockData createRemoteLock(String sessionId, String nodeIdentifier, String lockToken, boolean isDeep, boolean sessionScoped, String owner) {
        LockData lData = new LockData(nodeIdentifier, lockToken, isDeep, sessionScoped, owner, this.lockTimeOut);
        lData.addLockHolder(sessionId);
        this.locks.put(nodeIdentifier, lData);
        this.tokensMap.put(lockToken, lData);
        return lData;
    }

    protected void removeLock(String nodeIdentifier) {
        try {
            NodeData nData = (NodeData)this.dataManager.getItemData(nodeIdentifier);
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), SystemIdentity.SYSTEM, 0x800000);
            TransientItemData lockOwner = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKOWNER, 1)));
            changesLog.add(ItemState.createDeletedState(lockOwner));
            TransientItemData lockIsDeep = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKISDEEP, 1)));
            changesLog.add(ItemState.createDeletedState(lockIsDeep));
            if (lockOwner == null && lockIsDeep == null) {
                return;
            }
            this.dataManager.save(new TransactionChangesLog(changesLog));
        }
        catch (RepositoryException e) {
            this.log.error((Object)("Error occur during removing lock" + e.getLocalizedMessage()));
        }
    }

    @Managed
    @ManagedDescription(value="The number of active locks")
    public int getNumLocks() {
        return this.locks.size();
    }

    @Managed
    @ManagedDescription(value="Remove the expired locks")
    public void cleanExpiredLocks() {
        this.removeExpired();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    @Override
    public SessionLockManager getSessionLockManager(String sessionId, SessionDataManager transientManager) {
        return new SessionLockManagerImpl(sessionId, this, transientManager);
    }

    @Override
    public void closeSessionLockManager(String sessionId) {
    }
}

