/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.lucene.analysis.Analyzer;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.AdditionalNamespaceResolver;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRuleImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.misc.Pattern;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingConfigurationImpl
implements IndexingConfiguration {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.IndexingConfigurationImpl");
    private LocationFactory resolver;
    private ItemDataConsumer ism;
    private Map<InternalQName, List<IndexingRule>> configElements = new HashMap<InternalQName, List<IndexingRule>>();
    private AggregateRule[] aggregateRules;
    private Map<String, Analyzer> analyzers = new HashMap<String, Analyzer>();

    @Override
    public void init(Element config, QueryHandlerContext context, NamespaceMappings nsMappings) throws Exception {
        this.ism = context.getItemStateManager();
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(this.getNamespaces(config));
        this.resolver = new LocationFactory(nsResolver);
        NodeTypeDataManager ntReg = context.getNodeTypeDataManager();
        ArrayList<AggregateRuleImpl> idxAggregates = new ArrayList<AggregateRuleImpl>();
        NodeList indexingConfigs = config.getChildNodes();
        for (int i = 0; i < indexingConfigs.getLength(); ++i) {
            Node configNode = indexingConfigs.item(i);
            if (configNode.getNodeName().equals("index-rule")) {
                IndexingRule element = new IndexingRule(configNode);
                log.debug("Found rule '{}' for NodeType '{}'", (Object)element, (Object)element.getNodeTypeName());
                Set<InternalQName> subs = ntReg.getSubtypes(element.getNodeTypeName());
                subs.add(element.getNodeTypeName());
                for (InternalQName subTypeName : subs) {
                    List<IndexingRule> perNtConfig = this.configElements.get((Object)subTypeName);
                    if (perNtConfig == null) {
                        perNtConfig = new ArrayList<IndexingRule>();
                        this.configElements.put(subTypeName, perNtConfig);
                    }
                    log.debug("Registering it for name '{}'", (Object)subTypeName);
                    perNtConfig.add(new IndexingRule(element, subTypeName));
                }
                continue;
            }
            if (configNode.getNodeName().equals("aggregate")) {
                idxAggregates.add(new AggregateRuleImpl(configNode, this.resolver, this.ism));
                continue;
            }
            if (!configNode.getNodeName().equals("analyzers")) continue;
            NodeList childNodes = configNode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node analyzerNode = childNodes.item(j);
                if (!analyzerNode.getNodeName().equals("analyzer")) continue;
                String analyzerClassName = analyzerNode.getAttributes().getNamedItem("class").getNodeValue();
                try {
                    Class<?> clazz = Class.forName(analyzerClassName);
                    if (clazz == JcrStandartAnalyzer.class) {
                        log.warn("Not allowed to configure " + JcrStandartAnalyzer.class.getName() + " for a property. " + "Using default analyzer for that property.");
                        continue;
                    }
                    if (Analyzer.class.isAssignableFrom(clazz)) {
                        Analyzer analyzer = (Analyzer)clazz.newInstance();
                        NodeList propertyChildNodes = analyzerNode.getChildNodes();
                        for (int k = 0; k < propertyChildNodes.getLength(); ++k) {
                            Node propertyNode = propertyChildNodes.item(k);
                            if (!propertyNode.getNodeName().equals("property")) continue;
                            InternalQName propName = this.resolver.parseJCRName(IndexingConfigurationImpl.getTextContent(propertyNode)).getInternalName();
                            String fieldName = nsMappings.translateName(propName);
                            int idx = fieldName.indexOf(58);
                            Analyzer prevAnalyzer = this.analyzers.put(fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1), analyzer);
                            if (prevAnalyzer == null) continue;
                            log.warn("Property " + propName.getName() + " has been configured for multiple analyzers. " + " Last configured analyzer is used");
                        }
                        continue;
                    }
                    log.warn("org.apache.lucene.analysis.Analyzer is not a superclass of " + analyzerClassName + ". Ignoring this configure analyzer");
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.warn("Analyzer class not found: " + analyzerClassName, (Throwable)e);
                }
            }
        }
        this.aggregateRules = idxAggregates.toArray(new AggregateRule[idxAggregates.size()]);
    }

    @Override
    public AggregateRule[] getAggregateRules() {
        return this.aggregateRules;
    }

    @Override
    public boolean isIndexed(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIndexed(propertyName);
        }
        return true;
    }

    @Override
    public float getPropertyBoost(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getBoost(propertyName);
        }
        return 1.0f;
    }

    @Override
    public float getNodeBoost(NodeData state) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getNodeBoost();
        }
        return 1.0f;
    }

    @Override
    public boolean isIncludedInNodeScopeIndex(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIncludedInNodeScopeIndex(propertyName);
        }
        return true;
    }

    @Override
    public boolean useInExcerpt(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.useInExcerpt(propertyName);
        }
        return true;
    }

    @Override
    public Analyzer getPropertyAnalyzer(String fieldName) {
        if (this.analyzers.containsKey(fieldName)) {
            return this.analyzers.get(fieldName);
        }
        return null;
    }

    private IndexingRule getApplicableIndexingRule(NodeData state) {
        InternalQName[] mixTypes;
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.configElements.get((Object)state.getPrimaryTypeName());
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        for (InternalQName mixType : mixTypes = state.getMixinTypeNames()) {
            r = this.configElements.get((Object)mixType);
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule ir : rules) {
                if (!ir.appliesTo(state)) continue;
                return ir;
            }
        }
        return null;
    }

    private Properties getNamespaces(Node node) {
        Properties namespaces = new Properties();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:")) continue;
            namespaces.setProperty(attribute.getName().substring(6), attribute.getValue());
        }
        return namespaces;
    }

    private void createPropertyConfigs(Node config, Map<InternalQName, PropertyConfig> propConfigs, List<NamePattern> namePatterns) throws IllegalNameException, RepositoryException {
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("property")) continue;
            NamedNodeMap attributes = n.getAttributes();
            float boost = 1.0f;
            Node boostAttr = attributes.getNamedItem("boost");
            if (boostAttr != null) {
                try {
                    boost = Float.parseFloat(boostAttr.getNodeValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            boolean nodeScopeIndex = true;
            Node nsIndex = attributes.getNamedItem("nodeScopeIndex");
            if (nsIndex != null) {
                nodeScopeIndex = Boolean.valueOf(nsIndex.getNodeValue());
            }
            boolean isRegexp = false;
            Node regexp = attributes.getNamedItem("isRegexp");
            if (regexp != null) {
                isRegexp = Boolean.valueOf(regexp.getNodeValue());
            }
            boolean useInExcerpt = true;
            Node excerpt = attributes.getNamedItem("useInExcerpt");
            if (excerpt != null) {
                useInExcerpt = Boolean.valueOf(excerpt.getNodeValue());
            }
            PropertyConfig pc = new PropertyConfig(boost, nodeScopeIndex, useInExcerpt);
            if (isRegexp) {
                namePatterns.add(new NamePattern(IndexingConfigurationImpl.getTextContent(n), pc, this.resolver));
                continue;
            }
            InternalQName propName = this.resolver.parseJCRName(IndexingConfigurationImpl.getTextContent(n)).getInternalName();
            propConfigs.put(propName, pc);
        }
    }

    private PathExpression getCondition(Node config) throws IllegalNameException, RepositoryException {
        String propertyValue;
        InternalQName propertyName;
        int idx;
        int axis;
        Node conditionAttr = config.getAttributes().getNamedItem("condition");
        if (conditionAttr == null) {
            return null;
        }
        String conditionString = conditionAttr.getNodeValue();
        InternalQName elementTest = null;
        InternalQName nameTest = null;
        if (conditionString.startsWith("ancestor::")) {
            axis = 2;
            idx = "ancestor::".length();
        } else if (conditionString.startsWith("parent::")) {
            axis = 3;
            idx = "parent::".length();
        } else if (conditionString.startsWith("@")) {
            axis = 0;
            idx = "@".length();
        } else {
            axis = 1;
            idx = 0;
        }
        try {
            String name;
            if (conditionString.startsWith("element(", idx)) {
                int colon = conditionString.indexOf(44, idx + "element(".length());
                name = conditionString.substring(idx + "element(".length(), colon).trim();
                if (!name.equals("*")) {
                    nameTest = this.resolver.parseJCRName(ISO9075.decode(name)).getInternalName();
                }
                idx = conditionString.indexOf(")/@", colon);
                String type = conditionString.substring(colon + 1, idx).trim();
                elementTest = this.resolver.parseJCRName(ISO9075.decode(type)).getInternalName();
                idx += ")/@".length();
            } else if (axis == 2 || axis == 1 || axis == 3) {
                String name2 = conditionString.substring(idx, conditionString.indexOf(47, idx));
                if (!name2.equals("*")) {
                    nameTest = this.resolver.parseJCRName(ISO9075.decode(name2)).getInternalName();
                }
                idx += name2.length() + "/@".length();
            }
            int eq = conditionString.indexOf(61, idx);
            name = conditionString.substring(idx, eq).trim();
            propertyName = this.resolver.parseJCRName(ISO9075.decode(name)).getInternalName();
            int quote = conditionString.indexOf(39, eq) + 1;
            propertyValue = conditionString.substring(quote, conditionString.indexOf(39, quote));
        }
        catch (IndexOutOfBoundsException e) {
            throw new RepositoryException(conditionString);
        }
        return new PathExpression(axis, elementTest, nameTest, propertyName, propertyValue);
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    public Analyzer addPropertyAnalyzer(String propertyName, Analyzer analyzer) {
        return this.analyzers.put(propertyName, analyzer);
    }

    private class PathExpression {
        static final int SELF = 0;
        static final int CHILD = 1;
        static final int ANCESTOR = 2;
        static final int PARENT = 3;
        private final int axis;
        private final InternalQName elementTest;
        private final InternalQName nameTest;
        private final InternalQName propertyName;
        private final String propertyValue;

        PathExpression(int axis, InternalQName elementTest, InternalQName nameTest, InternalQName propertyName, String propertyValue) {
            this.axis = axis;
            this.elementTest = elementTest;
            this.nameTest = nameTest;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        boolean evaluate(final NodeData context) {
            Iterator<Object> nodeStates;
            block22: {
                if (this.axis == 0) {
                    nodeStates = Collections.singletonList(context).iterator();
                } else if (this.axis == 1) {
                    try {
                        List<NodeData> childs = IndexingConfigurationImpl.this.ism.getChildNodesData(context);
                        nodeStates = childs.iterator();
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.emptyList().iterator();
                    }
                } else if (this.axis == 2) {
                    try {
                        nodeStates = new Iterator(){
                            private NodeData next;
                            {
                                this.next = (NodeData)IndexingConfigurationImpl.this.ism.getItemData(context.getParentIdentifier());
                            }

                            public void remove() {
                                throw new UnsupportedOperationException();
                            }

                            public boolean hasNext() {
                                return this.next != null;
                            }

                            public Object next() {
                                NodeData tmp = this.next;
                                try {
                                    this.next = this.next.getParentIdentifier() != null ? (NodeData)IndexingConfigurationImpl.this.ism.getItemData(this.next.getParentIdentifier()) : null;
                                }
                                catch (RepositoryException e) {
                                    this.next = null;
                                }
                                return tmp;
                            }
                        };
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                } else if (this.axis == 3) {
                    try {
                        if (context.getParentIdentifier() != null) {
                            NodeData state = (NodeData)IndexingConfigurationImpl.this.ism.getItemData(context.getParentIdentifier());
                            nodeStates = Collections.singletonList(state).iterator();
                            break block22;
                        }
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                } else {
                    nodeStates = Collections.EMPTY_LIST.iterator();
                }
            }
            while (nodeStates.hasNext()) {
                try {
                    NodeData current = nodeStates.next();
                    if (this.elementTest != null && !current.getPrimaryTypeName().equals((Object)this.elementTest) || this.nameTest != null && !current.getQPath().getName().equals((Object)this.nameTest)) continue;
                    List<PropertyData> childProps = IndexingConfigurationImpl.this.ism.getChildPropertiesData(current);
                    PropertyData propState = null;
                    for (PropertyData propertyData : childProps) {
                        if (!propertyData.getQPath().getName().equals((Object)this.propertyName)) continue;
                        propState = propertyData;
                        break;
                    }
                    if (propState == null) continue;
                    List<ValueData> values = propState.getValues();
                    if (propState.getType() == 2) continue;
                    try {
                        for (int i = 0; i < values.size(); ++i) {
                            byte[] bytes = values.get(i).getAsByteArray();
                            String val = new String(bytes, "UTF-8");
                            if (!val.equals(this.propertyValue)) continue;
                            return true;
                        }
                    }
                    catch (IOException e) {
                        log.error(e.getLocalizedMessage());
                    }
                }
                catch (RepositoryException e) {
                    log.error(e.getLocalizedMessage());
                }
            }
            return false;
        }
    }

    private class PropertyConfig {
        final float boost;
        final boolean nodeScopeIndex;
        final boolean useInExcerpt;

        PropertyConfig(float boost, boolean nodeScopeIndex, boolean useInExcerpt) {
            this.boost = boost;
            this.nodeScopeIndex = nodeScopeIndex;
            this.useInExcerpt = useInExcerpt;
        }
    }

    private class IndexingRule {
        private final InternalQName nodeTypeName;
        private final Map<InternalQName, PropertyConfig> propConfigs;
        private final List<NamePattern> namePatterns;
        private final PathExpression condition;
        private final float boost;

        IndexingRule(IndexingRule original, InternalQName nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.propConfigs = original.propConfigs;
            this.namePatterns = original.namePatterns;
            this.condition = original.condition;
            this.boost = original.boost;
        }

        IndexingRule(Node config) throws IllegalNameException, RepositoryException {
            this.nodeTypeName = this.getNodeTypeName(config);
            this.condition = IndexingConfigurationImpl.this.getCondition(config);
            this.boost = this.getNodeBoost(config);
            this.propConfigs = new HashMap<InternalQName, PropertyConfig>();
            this.namePatterns = new ArrayList<NamePattern>();
            IndexingConfigurationImpl.this.createPropertyConfigs(config, this.propConfigs, this.namePatterns);
        }

        public InternalQName getNodeTypeName() {
            return this.nodeTypeName;
        }

        public float getNodeBoost() {
            return this.boost;
        }

        public boolean isIndexed(InternalQName propertyName) {
            return this.getConfig(propertyName) != null;
        }

        public float getBoost(InternalQName propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.boost;
            }
            return 1.0f;
        }

        public boolean isIncludedInNodeScopeIndex(InternalQName propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.nodeScopeIndex;
            }
            return false;
        }

        public boolean useInExcerpt(InternalQName propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.useInExcerpt;
            }
            return true;
        }

        public boolean appliesTo(NodeData state) {
            if (!this.nodeTypeName.equals((Object)state.getPrimaryTypeName())) {
                return false;
            }
            if (this.condition == null) {
                return true;
            }
            return this.condition.evaluate(state);
        }

        private PropertyConfig getConfig(InternalQName propertyName) {
            PropertyConfig config = this.propConfigs.get((Object)propertyName);
            if (config != null) {
                return config;
            }
            if (this.namePatterns.size() > 0) {
                QPath path = new QPath(new QPathEntry[]{new QPathEntry(propertyName, 1)});
                for (NamePattern np : this.namePatterns) {
                    if (!np.matches(path)) continue;
                    return np.getConfig();
                }
            }
            return null;
        }

        private InternalQName getNodeTypeName(Node config) throws IllegalNameException, RepositoryException {
            String ntString = config.getAttributes().getNamedItem("nodeType").getNodeValue();
            return IndexingConfigurationImpl.this.resolver.parseJCRName(ntString).getInternalName();
        }

        private float getNodeBoost(Node config) {
            Node boost = config.getAttributes().getNamedItem("boost");
            if (boost != null) {
                try {
                    return Float.parseFloat(boost.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 1.0f;
        }
    }

    private static final class NamePattern {
        private final Pattern pattern;
        private final PropertyConfig config;

        private NamePattern(String pattern, PropertyConfig config, LocationFactory resolver) throws IllegalNameException, RepositoryException {
            String uri = "";
            String localPattern = pattern;
            int idx = pattern.indexOf(58);
            if (idx != -1) {
                uri = resolver.parseJCRName(pattern.substring(0, idx) + ":a").getNamespace();
                localPattern = pattern.substring(idx + 1);
            }
            this.pattern = Pattern.name(uri, localPattern);
            this.config = config;
        }

        boolean matches(QPath path) {
            return this.pattern.match(path).isFullMatch();
        }

        PropertyConfig getConfig() {
            return this.config;
        }
    }
}

